Attribute VB_Name = "srt_main"
'VB SORTING CLASS DEMO
'January, 2006

' Philip Bolt, 2006

'A limit of this demo is that the display strings exceed the maximum length of a string
'for more than 12600 integers. As variable length strings can't be defined with a variable,
'this curtailment is ignored: the process works; the display is incomplete.

Public src() As Variant             'The data source array.

Public k_f() As Integer             'The key field array for multiple field sorts.
Public ni As Integer                'Number of random integers, (data for sorting).
Public fi As Integer                'Number of fields for a multi-field sort or zero.
Public pt As Integer                'General row pointer.
Public max_int As Long              'Maximum value for an integer.

Public data_file As String          'Names data file name.

Public strt As Single               'Starting time.
Public tme As Single                'Timed delay in seconds.

Public datum As Boolean             'Random numbers generated' flag.
Public asc_des As Boolean           'Ascending/Descending sort flag.
Public conv_sort As Boolean         'Conventional sorting flag.

Public srt As Object                'The 'Sort' object.

Sub set_up()
 
    datum = False               'Clear the random number and
    conv_sort = False           'conventional sorting flags.
    
    sort_main.Visible = True    'Show the form and
    sort_main.Text1.SetFocus    'set the cursor to the 'Number of numbers' box.
    
    max_int = 32767
    
    Set srt = New sort          'Define the sort object.
    
    data_file = App.Path + "\" + "name.dta"

End Sub

'Routine to generate a set of 'n' random numbers.
'The data is stored in the 'src()' array.
'Procedure name:    generate_random_numbers

Sub generate_random_numbers()
 
    ReDim src(ni)  'Redimension the working array.
    
    sort_main.Text2.Text = ""       'Clear the text box and
    sort_main.Label5.Caption = ""   'the 'Time' label.
    
    txt = ""
    
    For j = 1 To ni
        r_num = Int(Rnd * ni + 1)       'Store the random number
        src(j) = r_num                  'in the 'src()' array and
        txt = txt + CStr(src(j)) + " "   'add it to the display.
    Next
    
    datum = True                    'Flag that a set of data exists.

    sort_main.Text2.Text = txt      'Display the numbers.
    
End Sub

'Routine to generate a set of 'n' random numbers with 'f' fields.
'The data is stored in the 2D 'src()' array.
'Procedure name:    generate_random_numbers

Sub generate_random_numbers2()
 
    ReDim src(ni, fi)  'Redimension the working array.
    
    sort_mf.Text3.Text = ""       'Clear the text box and
    sort_mf.Label3.Caption = ""   'the 'Time' label.
    
    txt = ""
    
    For j = 1 To ni
        For k = 1 To fi
            r_num = Int(Rnd * fi / 2 + 1)   'Store the random number
            src(j, k) = r_num                 'in the 'src()' array and
            txt = txt + CStr(src(j, k)) + "  "  'add it to the display.
        Next
        txt = txt + vbCrLf
    Next
    
    datum = True                    'Flag that a set of data exists.

    sort_mf.Text3.Text = txt      'Display the numbers.
    
End Sub

'Routine to generate a set of n strings of length between 1 and 8 characters.
'The data is stored in the 'src()' array.
'Procedure name:    generate_strings

Sub generate_strings()

    ReDim src(ni)  'Redimension the working array.

    sort_main.Text2.Text = ""       'Clear the text box and
    sort_main.Label5.Caption = ""   'the 'Time' label.
    
    txt = ""
    
    For j = 1 To ni
        l_str = Int(Rnd * 8 + 1)    'Get a random string length, 1 - 8
        d_str = ""
        cha = 0                     'Initialise the length count and
        Do Until cha = l_str        'use a loop to generate a string of random characters.
            nxt_chr = Int(Rnd * 57 + 65)
            If nxt_chr < 91 Or nxt_chr > 96 Then    'Use only A - Z and a - z.
                d_str = d_str + Chr(nxt_chr)
                cha = cha + 1
            End If
        Loop
        src(j) = d_str              'Store the string in the 'src()' array and
        txt = txt + d_str + "   "   'add it to the display string.
    Next
    
    datum = True                    'Flag that a set of data exists.

    sort_main.Text2.Text = txt      'Display the strings.
    
End Sub

'Routine to display the contents of the 'src()' array.
'Procedure name:    display( )

Sub display()
   
    srt.retirn src()    'Return the sorted data to the 'src()' array.

    txt = ""
    
    If fi = 0 Then
        For j = 1 To ni
            txt = txt + CStr(src(j)) + "    "
        Next
     
        sort_main.Text2.Text = txt          'Display the numbers and the time taken.
        sort_main.Label5.Caption = "Time taken: " + Format(tme, "0.00") + " sec."
    Else
        For j = 1 To ni
            For k = 1 To fi
                txt = txt + CStr(src(j, k)) + "  "  'Add it to the display.
            Next
            txt = txt + vbCrLf
        Next
        sort_mf.Text3.Text = txt          'Display the data and the time taken.
        sort_mf.Label3.Caption = "Time taken: " + Format(tme, "0.00") + " sec."
    End If
    
End Sub

'Routine to process the text name data
'Procedure name:    process_text_data

Sub load_text_data()

    txt = ""

    'Load the text data into the 'src()' array.
    Open data_file For Input As #1
        Input #1, ni, fi        'Read the records and fields.
        ReDim src(ni, fi + 1)
        For j = 1 To ni
            For k = 1 To fi
                Input #1, src(j, k)
                txt = txt + src(j, k) + " "
            Next
            txt = txt + vbCrLf
        Next
    Close #1
    
    sort_mf.Text3.Text = txt    'Display the data.
    
    conv_sort = True            'Flag that this is to be a conventional sort.
    
End Sub
