VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "sort"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

'SORT CLASS

'This class provides code for several 1D data array sorts, (Bubble, Exchange, Insertion,
'Shell, Quick and Tree), and a multi-field Shell sort which can be used as a template for
'other multi-field algorithms. The provision exists with the multi-field sort to use UK
'conventional alphabetic sorting on one field, (surnames).

'This form of the class is written for the sorting of data where the number of items to
'be sorted is an integer.

'This limit can be changed by redimensioning the INTEGER variables concerned as LONG.

'The code was written with variant data types to allow different forms of data even though this
'will slow the process.

' Philip Bolt, 2005 - 2006

'Last updated:  21/10/6

Option Explicit
Option Compare Binary               'Needed to sort strings conventionally.

Private dta() As Variant            'The data array to be sorted, (match DATA TYPE for more speed).

Private index() As Integer          'Index array for multi-field sorts.
Private a_s_v() As Integer          'The number of special starting sections, Mac, Mc, etc.

Private n_i As Integer              'The number of items of data.
Private n_a_s As Integer            'The number of alpha sections.

Private n_fld As Integer            'The number of fields in a multi-field sort.
Private keys() As Integer           'Multi-field sort, KEY fields array.

Private stack() As Integer          'Quick' sort stack array.

Private node As Integer             'Tree' sort node count.

Private tree() As Variant           'Tree' sort storage array. NB if data other than integer
                                    'is to be used, 'tree()', has to be variant or a parallel
                                    'array is needed as the subscript 1 & 2 items are numeric.

Private a_char() As String          'Alpha sorting 1st. characters, M, etc.
Private a_strs() As String          'Alpha sorting 1st sections, Mac, Mc, etc.

Private swopped As Boolean          'Exchanged data flag.
Private setup As Boolean            'Data set up flag.

'Object constructor.
'Run when the object is created.

Private Sub Class_Initialize()

    If Not setup Then
        set_up
    End If

End Sub

'Procedure name:    Class_Terminate()
'Run when a page is terminated.

Private Sub Class_Terminate()
 
End Sub

'Routine to set up the stored data.
'Procedure name:    set_up

Sub set_up()

    n_a_s = 2           'Define the number of special alpha areas.
    ReDim a_char(n_a_s)
    a_char(1) = "M"     'Store the inital character of the special areas.
    a_char(2) = "S"
    
    ReDim a_strs(n_a_s, 2), a_s_v(n_a_s)
    a_s_v(1) = 2            'Define the number of special starting texts.
    a_strs(1, 0) = "Mac"    'Store the default group prefix section and
    a_strs(1, 1) = "M'"     'the name prefixes to be grouped.
    a_strs(1, 2) = "Mc"
        
    a_s_v(2) = 2            'Define the number of special starting texts.
    a_strs(2, 0) = "Saint"  'Store the default group prefix section and
    a_strs(2, 1) = "St."    'the name prefixes to be grouped.
    a_strs(2, 2) = "St"
    
    setup = True 'Set the Setup flag.

End Sub

'Routine to transfer the data FROM the main program TO the class object.
'The method also defines 'n_i' for the sorts and 'n_fld' for multi-field sorts.
'The data array will be 1D if flds = 0 or 2D for flds > 0.

'Procedure name:    transfer(ByRef arr() As Variant, num, flds As Integer)
'Parameter:         arr();  the data source array, (declare to match DATA TYPE),
'                   num;    the number of items, (integers).
'                   flds;   the number of fields, 0 = 1D array, else 2D.

Public Sub transfer(ByRef arr() As Variant, num As Integer, flds As Integer)

    Dim j, k As Integer    'Dimension the loop counter.
    
    If flds >= 0 And num > 1 Then
        If flds = 0 Then    'The data is for a 1D array,
            ReDim dta(num)  'the data processing array.
    
            For j = 1 To num    'Transfer the data to the class object array.
                dta(j) = arr(j)
            Next
        Else                        'Otherwise, it's a 2D array,
            ReDim dta(num, flds)    'the data processing array.
    
            For j = 1 To num        'Transfer the data to the class object array.
                For k = 1 To flds
                    dta(j, k) = arr(j, k)
                Next
            Next
        End If
    
        n_i = num       'Store the number of items and
        n_fld = flds    'the fields.
    Else 'it's an error, so
        If flds < 0 Then
            MsgBox "The number of fields must be positive.", vbOKOnly + vbCritical, "DATA ERROR"
        Else
            MsgBox "There must be more than 1 item of data.", vbOKOnly + vbCritical, "DATA ERROR"
        End If
    End If
    
End Sub

'Routine to return the sorted data FROM the class object TO the main program.
'The data array can be 1 or 2D.

'Procedure name:    retirn(ByRef arr() As Variant)
'Parameter:         arr();  the main program array, (declare to match DATA TYPE).

Public Sub retirn(ByRef arr() As Variant)

    Dim j, k As Integer     'Dimension the loop counters.
    
    If n_fld = 0 Then
        For j = 1 To n_i    'Return the data to a main program, 1D array.
            arr(j) = dta(j)
        Next
    Else
        For j = 1 To n_i        'Return the data to a main program, 2D array.
            For k = 1 To n_fld
                arr(j, k) = dta(index(j), k)    'Take the data as indicated by the Index array.
            Next
        Next
    End If

End Sub

'Bubble sort routine.
'Procedure name:    bubble_srt(a_d As Boolean)

Public Sub bubble_srt(a_d As Boolean)

    Dim j As Integer
  
    Do 'until no more exchanges are made.
        swopped = False 'Clear the exchange flag.
        For j = 2 To ni
            If (dta(j) < dta(j - 1) And a_d) Or (dta(j) > dta(j - 1) And Not a_d) Then
                xchange j, j - 1    'Exchange records.
            End If
        Next
    Loop While swopped
    
End Sub

'This is the EXCHANGE sort.
'Procedure name:    exchange_srt(a_d As Boolean)

Public Sub exchange_srt(a_d As Boolean)

    Dim j, k, minn As Integer

    For j = 1 To ni - 1
        minn = j
        For k = j + 1 To ni
            If (dta(k) < dta(minn) And a_d) Or (dta(k) > dta(minn) And Not a_d) _
                Then
                minn = k    'Find the subscript of the SMALLEST or LARGEST value.
            End If
        Next
        xchange j, minn 'Exchange records.
    Next
        
End Sub

'This is the INSERTION sort.
'Procedure name:    insertion_srt(a_d As Boolean)

Public Sub insertion_srt(a_d As Boolean)

    Dim j, k As Integer
    Dim temp As Variant     'Or data type.

    For j = 1 To n_i - 1
        If (dta(j) > dta(j + 1) And a_d) Or (dta(j) < dta(j + 1) And Not a_d) Then
            temp = dta(j + 1)   'Store out of order data.
            k = j
            Do While k >= 1 And ((dta(k) > temp And a_d) Or (dta(k) < temp And Not a_d))
                dta(k + 1) = dta(k) 'Shift data until required position found.
                k = k - 1
            Loop
            dta(k + 1) = temp   'Insert the stored value.
        End If
    Next
   
End Sub

'QUICK sort routine.
'Procedure name:    quick_srt(a_d As Boolean)

Public Sub quick_srt(a_d As Boolean)

    Dim stk, b_lst, e_lst As Integer    'Stack pointer and values.
    Dim pt1, pt2 As Integer             'Operational pointers.
    Dim strr As Variant                 'Storage.
    
    ReDim stack(n_i * 1.5, 1)    'Dimension the stack array with 50% excess space.
     
    stk = 0 'Set the initial stack pointer.
 
    push 1, n_i, stk 'Push the initial values onto the stack.
  
    Do While stk <> 0
        b_lst = stack(stk, 0)   'Pop the stack values to give
        e_lst = stack(stk, 1)   'the beginning and end of list values.
        stk = stk - 1           'Decrement the stack pointer.
        pt1 = b_lst             'Transfer the list limits to operational pointers.
        pt2 = e_lst
        
        strr = dta(pt1)         'Store a data record.
        Do While pt1 <> pt2
            Do While pt1 <> pt2 And ((strr <= dta(pt2) And a_d) Or (strr >= dta(pt2) And Not _
                    a_d))
                pt2 = pt2 - 1 'Decrement pt2
            Loop 'pt1 <> pt2, etc.
            dta(pt1) = dta(pt2) 'Transfer a record, pt2 to pt1.
            Do While pt1 <> pt2 And ((strr >= dta(pt1) And a_d) Or (strr <= dta(pt1) And Not _
                    a_d))
                pt1 = pt1 + 1 'Increment pt1
            Loop 'pt1 <> pt2, etc.
            dta(pt2) = dta(pt1) 'Transfer a record, pt1 to pt2.
        Loop 'pt1 <> pt2
        
        dta(pt1) = strr 'Replace the stored record.
        If b_lst <> pt1 Then 'push a new pair of values onto the stack.
            push b_lst, pt1 - 1, stk
        End If
        
        If e_lst <> pt1 Then 'push a new pair of values onto the stack.
            push pt1 + 1, e_lst, stk
        End If
    Loop 'While stk <> 0
    
End Sub

'Routine to push values onto the 'Quick' sort stack
'Procedure name:    push(n1, n2, ByRef stk)
'Parameters:        n1, n2; the numbers to be added to the stack,
'                   stk;    the stack pointer.

Private Sub push(n1, n2, ByRef stk)

    stk = stk + 1
    stack(stk, 0) = n1
    stack(stk, 1) = n2
    
End Sub

'Routine to exchange a pair of 1D 'dta()' elements.
'Procedure name:    xchange( r1, r2)
'Parameters:        r1, r2; the records concerned.

Private Sub xchange(r1, r2)

    Dim temp As Variant 'or match DATA TYPE.

    temp = dta(r1)
    dta(r1) = dta(r2)
    dta(r2) = temp
    
    swopped = True
    
End Sub

'Shell sort routine.
'Procedure name:    shell_srt(a_d As Boolean)

Public Sub shell_srt(a_d As Boolean)

    Dim i, j, k, l, m As Integer
     
    m = n_i
    m = Int(m / 2)  'Get an initial value for m.
    
    Do  'while m>0
        k = n_i - m
        j = 1
        Do  'while j<=k
            i = j
            Do  'while i>=1 AND swopped
                l = i + m
                swopped = False
                If (dta(i) > dta(l) And a_d) Or (dta(i) < dta(l) And Not a_d) Then 'exchange them
                    xchange i, l
                    i = i - m
                End If
            Loop While i >= 1 And swopped
            j = j + 1
        Loop While j <= k
        m = Int(m / 2)
    Loop While m <> 0

End Sub

'This is the Tree sort.
'In this example, one variant array is used for both the data and the pointers.
'If more speed is needed, an array matching the DATA TYPE could be used with a separate
'array for the pointers.

Public Sub tree_srt(a_d As Boolean)

    Dim j, st As Integer

    ReDim tree(ni + 1, 2)   'Dimension the 'Tree' array and
    tree(1, 0) = -30000     'set the sentinel values.
    tree(1, 1) = -1
    tree(1, 2) = -1
    
    node = 2
    
    'Populate the tree.
    For j = 1 To n_i
        load_tree dta(j)
    Next
    
    'Sort the tree.
    node = 1        'Initialise the storage array subscript and
    st = tree(1, 2) 'store the starting value.
    
    in_order st, a_d    'Use the recursive function to sort the tree data.
   
End Sub

'Routine to load a value onto the tree and establish its links.
'Procedure name:    load_tree(itm, ad)
'Parameter:         itm;    the item of data.

Private Sub load_tree(itm)

    Dim i, k As Integer
 
    tree(node, 0) = itm     'Store the item and
    tree(node, 1) = -1      'initialise the L & R pointers.
    tree(node, 2) = -1
    
    i = 1
    Do While i <> -1
        If itm < tree(i, 0) Then
            k = i
            i = tree(i, 1)
            If i = -1 Then
                tree(k, 1) = node
            End If
        Else
            k = i
            i = tree(i, 2)
            If i = -1 Then
                tree(k, 2) = node
            End If
        End If
    Loop
    
    node = node + 1

End Sub

'Recursive routine to sort a tree in order.
'Procedure name:    in_order(vl, ad)
'Parameter:         vl; the node position value,
'                   ad; the Ascending/Descending sort flag.

Private Sub in_order(vl, ad)

    If vl <> -1 Then    'If this is not a dead end,
        If ad Then                      'This is an ASCENDING sort, so
            in_order tree(vl, 1), ad    'search LEFT, one level down.
            dta(node) = tree(vl, 0)     'Store the value and
            node = node + 1             'increment the array subscript.
            in_order tree(vl, 2), ad    'Search RIGHT, one level down.
        Else                            'This is a DESCENDING sort, so
            in_order tree(vl, 2), ad    'search RIGHT, one level down.
            dta(node) = tree(vl, 0)     'Store the value and
            node = node + 1             'increment the array subscript.
            in_order tree(vl, 1), ad    'Search LEFT, one level down.
        End If
    End If
    
End Sub

'Routine to sort a data array on multiple fields.
'The number of fields is given by 'n_fld' and the data array is dimensioned as 'dta(n_i, n_fld)'
'The array is sorted by the recursive procedure, 'MF_sort', shown below.
'Whilst this uses a Shell sort, it would be possible to replace this with any other sort.

'Procedure name:    MF_srt(ByRef ks() As Integer, Optional a_d As Boolean = True,
'                           Optional alfa As Integer = 0)
'Parameters:        ks();   the key field storage array,
'                   a_d;    the Ascending/Descending sort flag.
'                               The optional default is True.
'                   alfa;   the conventional alphabetic flag.
'                               The optional default is zero = strictly text sorted.
'                               Otherwise, the number of the main text field, (Surname).

Public Sub MF_srt(ByRef ks() As Integer, Optional a_d As Boolean = True, _
                    Optional alfa As Integer = 0)

    Dim j As Integer
    Dim k_f As Boolean  'Key found flag.
    
    ReDim keys(n_fld), index(n_i)

    For j = 0 To n_i
        index(j) = j        'Load the index array.
    Next
    
    k_f = False 'Set a default for the 'Key Found' flag.
    For j = 0 To n_fld - 1
        keys(j) = ks(j)     'Store the key field numbers in the class key array.
        If alfa > 0 And keys(j) = alfa Then 'this is the main text field, so
            k_f = True  'set the 'Key Found' flag.
        End If
    Next
    
    If Not k_f And alfa > 0 Then 'the main text key isn't in the key field array, so
        MsgBox "The main text field must be included as a key field", "FIELD ERROR"
    Else
        If k_f Then
            load_extra_field alfa       'Set up the extra field for conventional sorting.
        End If
        MF_sort 1, n_i, 0, a_d, alfa    'Initial sort call.
    End If
    
End Sub

'Routine to set up an extra field for text reduced to conventional sorting format
'for UK ENGLISH. i.e. M', Mc are treated as 'Mac' and St, St. are treated as 'Saint'.
'Apostrophes and hyphens are removed but spaces are NOT.

'It would be possible but not easy to modified this for other languages.

'Procedure name:    load_extra_field
'Parameter:         tf; the main text field

Sub load_extra_field(tf)

    Dim j, k, l, sz As Integer
    Dim s_nme As String
    Dim replaced As Boolean     'Replaced text flag.
    
    ReDim Preserve dta(n_i, n_fld + 1)  'Redimension the data array with an extra field.
    
    For j = 1 To n_i
        replaced = False    'Clear the 'Field replaced' flag.
        For k = 1 To n_a_s
            If Left(dta(j, tf), 1) = a_char(k) Then 'this is a special area, so
                For l = 1 To a_s_v(k)           'Check each starting section.
                    sz = Len(a_strs(k, l))      'Store the length of the section.
                    If Left(dta(j, tf), sz) = a_strs(k, l) Then 'this name has the start section, so
                        s_nme = Right(dta(j, tf), Len(dta(j, tf)) - sz)  'Store the stripped name,
                        s_nme = a_strs(k, 0) + s_nme    'add the default prefix and
                        dta(j, n_fld + 1) = s_nme       'store the formalised name in the extra field.
                        replaced = True 'Set the 'Field replaced' flag.
                    End If
                Next
            End If
        Next
        
        If Not replaced Then    'If not already replaced,
            Select Case True    'remove any ' and - before transfering the name field.
                Case InStr(dta(j, tf), "'") > 0 'there are apostrophes in the name, so
                    dta(j, n_fld + 1) = Replace(dta(j, tf), "'", "")   'store the text with 's removed.
                Case InStr(dta(j, tf), "-") > 0 'there are hyphens in the name, so
                    dta(j, n_fld + 1) = Replace(dta(j, tf), "-", "")   'store the text with -s removed.
                Case Else 'just store the name.
                    dta(j, n_fld + 1) = dta(j, tf)
            End Select
        End If
    Next

End Sub

'Procedure name:    MF_sort(keys() as integer, fd, a_d As Boolean)
'Parameters:        strt & ndd; the first and last data array subscripts for the current block,
'                   fd;         the current key field, (keys() subscript),
'                   a_d;        the Ascending/Descending sort flag.
'                                   The optional default is True.
'                   alf;        the conventional alphabetic flag.
'                                   The optional default is zero = strictly text sorted.
'                                   Otherwise, the number of the main text field, (Surname).

'This is used recursively to sort blocks of data on the prescribed fields.

'To use a different sorting algorithm, just change the 'MF_shell_srt' reference and
'modify the required algorithm for multiple fields as has been done for the Shell sort.

Private Sub MF_sort(strt As Integer, ndd As Integer, fd As Integer, _
                    Optional a_d As Boolean = True, Optional alf As Integer = 0)

    Dim c_fld, frst, lst, cnt As Integer
    Dim vlu As Variant  'or DATA TYPE.
 
    If keys(fd) <> 0 Then   'Check for the final field being exceeded.
        c_fld = keys(fd)    'Store the current key field.
 
        If alf = c_fld Then 'sort the data according to the alphabetic convention.
            MF_shell_srt strt, ndd, n_fld + 1, a_d 'Sort the data on the formalised field.
        Else
            MF_shell_srt strt, ndd, c_fld, a_d  'Sort the data as usual.
        End If
    
        frst = strt                 'Store the start value,
        cnt = strt                  'set the array pointer and
        vlu = dta(index(cnt), c_fld) 'store the current data value.
 
        Do Until cnt = ndd          'Loop through this block of data.
            cnt = cnt + 1           'Increment the count
            If dta(index(cnt), c_fld) <> vlu Then 'there is a new value, so
                lst = cnt - 1                               'set the last value for this block and
                MF_sort (frst), (lst), (fd + 1), a_d, alf   'sort the block on the next field.
                frst = cnt: vlu = dta(index(cnt), c_fld)    'Reset the block pointers for the next
            End If                                          'block.
        Loop
        
        If cnt > frst Then 'there's still some data to be sorted, so
            MF_sort (frst), (cnt), (fd + 1), a_d, alf 'sort the block.
        End If
  End If
  
End Sub

'Shell sort routine for multiple field sorts.
'This sorts a block of data defined by 'st' and 'nd' on the basis of the current field, 'fld'.
'This version sorts on the basis of an index array, 'index()'.

'Procedure name:    MF_shell_srt(st, nd, fld, ad As Boolean)
'Parameters:        st, nd; the start and end array subscripts of the current block,
'                   fld;    the sorting field subscript,
'                   ad;     the Ascending/Descending sort flag.
'                               The optional default is True.

Private Sub MF_shell_srt(st, nd, fld, Optional ad As Boolean = True)
 
    Dim i, j, k, l, m, n, ofs As Integer
    
    ofs = st - 1    'Store the data array subscript offset and
    n = nd - st + 1 'the number of items in this block.
 
    If n > 1 Then 'sort the data.
        m = n
        m = Int(m / 2)      'Get an initial value for m.
 
        Do  'while m>0
            k = n - m
            j = 1
            Do  'while j<=k
                i = j
                Do  'while i>=1 AND  swopped
                    l = i + m
                    swopped = False     'Clear the exchanged data flag.
                    If (dta(index(i + ofs), fld) > dta(index(l + ofs), fld) And ad) Or (dta(index(i + ofs), fld) _
                        < dta(index(l + ofs), fld) And Not ad) Then 'exchange them
                        index_xchange i + ofs, l + ofs
                        i = i - m
                    End If
                Loop While i >= 1 And swopped
                j = j + 1
            Loop While j <= k
            m = Int(m / 2)
        Loop While m > 0
    End If 'there is data needing sorting.

End Sub

'Routine to exchange a pair of 2D data elements via their indices.
'Procedure name:    index_xchange( r1, r2)
'Parameters:        r1, r2; the records concerned.

Private Sub index_xchange(r1, r2)

    Dim temp As Integer
    
    temp = index(r1)        'Store the first index,
    index(r1) = index(r2)   'replace the first by the second and
    index(r2) = temp        'replace the second by the first
                            'to complete the exchange.
    
    swopped = True          'Set the exchanged data flag.
    
End Sub

