Attribute VB_Name = "graphics_main"

Option Explicit

Public file_type() As String    'File type text array.

Public setup As Boolean         'Set up flag.

Public gf As Object

Sub set_up()

    Dim j As Integer
    
    For j = 0 To 3
        With grph_main.Label2(j)
            .Width = 7000
            .Height = 450
            .Left = (grph_main.Width - .Width) / 2
            .Top = 1700 + j * 500
            Select Case j
                Case 0
                    .Caption = "File type:"
                Case 1
                    .Caption = "Width:"
                Case 2
                    .Caption = "Height:"
                Case 3
                    .Caption = "Depth:"
            End Select
        End With
    Next
    
    grph_main.Height = grph_main.Label2(3).Top + 1200
    grph_main.Icon = LoadPicture("redhall.ico")
    
    Set gf = New GraphicSize    'Define the GraphicSize  object.
    
    ReDim file_type(13)          'Store the available file type text.
    For j = 0 To 13
        file_type(0) = "UNKNOWN"
        file_type(1) = "GIF"
        file_type(2) = "JPEG"
        file_type(3) = "PNG"
        file_type(4) = "BITMAP"
        file_type(5) = "ICON"
        file_type(6) = "TIFF"
        file_type(7) = "PCX"
        file_type(8) = "TARGA, v2"
        file_type(9) = "PSD"
        file_type(10) = "PSB"
        file_type(11) = "EPS"
        file_type(12) = "PS"
        file_type(13) = "AI"
    Next
    
    setup = True

End Sub

'Routine to find the WIDTH, HEIGHT and DEPTH, (bits/pixel), of the image.
'Procedure name:    get_graphic_data

Sub get_graphic_data()

    Dim flnme As String

    'Check for a file name.
    If grph_main.Text1.Text <> "" Then 'there is some text.
        flnme = grph_main.Text1.Text
        
        On Error GoTo err_check
        
        Open flnme For Input As #1  'Open the file to check that it exists.
        Close #1
        
        On Error GoTo 0             'Clear the 'On error' jump.
        
        gf.ReadImageInfo flnme      'Call the GraphicSize object READ DATA method.
        
        'Use the GraphicSize objects properties to display the file data.
        grph_main.Label2(0).Caption = "File type: " + file_type(gf.ImageType)
        
        Select Case gf.ImageType
            Case 5 'is an ICON, so
                grph_main.Label2(1).Caption = "Number of images: " + CStr(gf.Depth)
                grph_main.Label2(2).Caption = ""
                grph_main.Label2(3).Caption = ""
            Case 11, 12, 13 'are Adobe types, so
                grph_main.Label2(1).Caption = "Width: " + CStr(gf.Width) + "pixels"
                grph_main.Label2(2).Caption = "Height: " + CStr(gf.Height) + "pixels"
                grph_main.Label2(3).Caption = "" 'No colour depth info.
            Case Else
                grph_main.Label2(1).Caption = "Width: " + CStr(gf.Width) + "pixels"
                grph_main.Label2(2).Caption = "Height: " + CStr(gf.Height) + "pixels"
                grph_main.Label2(3).Caption = "Depth: " + CStr(gf.Depth) + "bits/pixel"
        End Select
    End If
    
Exit Sub

err_check:
        
    If Err.Number = 53 Then
        MsgBox "The file '" + flnme + "' doesn't exist!"
    End If
    
    Close #1
    
End Sub
