VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "GraphicSize"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

'CImageInfo, (renamed as GraphicSize by phb).
'
'Author: David Crowell
'davidc@qtm.net
'http://www.qtm.net/~davidc
'
'Released to the public domain
'use however you wish
'
'CImageInfo will get the image type ,dimensions, and
'color depth from JPG, PNG, BMP, and GIF files.
'
'version date: June 16, 1999
'
'http://www.wotsit.org is a good source of
'file format information.  This code would not have been
'possible without the files I found there.

'v1.0
'Modified to cover .ICO, .PCX, .TGA and .TIF files and cleaned up a little by
'Philip Bolt, May 2011.

'v1.1, 24/5/2011
'To deal with TIFF files, the two byte multiplication function, 'Mult', had to be
're-written with an 'Endian' flag and the four byte, 'BigMult', function created.

'v1.2, 27/5/2011
'Routines added for Adobe files, (.PSB, .PSD, .EPS, .PS and .AI files).

Option Explicit

'Only the first X bytes of the file are read into a byte array.
'BUFFERSIZE is X.  A larger number will use more memory and
'be slower.  A smaller number may not be able to decode all
'JPEG files.  Feel free to play with this number.
Private Const BUFFERSIZE As Long = 65535
Private Const tga_sig As String = "TRUEVISION-XFILE"
Private Const psb_sig As String = "8BPS"
Private Const adobe_sig As String = "%!PS-Adobe"
Private Const creator_tag As String = "%%Creator"
Private Const ai_sig As String = "Adobe Illustrator"
Private Const bb_tag As String = "%%BoundingBox"
Private Const comm_tag As String = "%%"

'Image type enum
Public Enum eImageType
    itUNKNOWN = 0
    itGIF = 1
    itJPEG = 2
    itPNG = 3
    itBMP = 4
    itICO = 5
    itTIFF = 6
    itPCX = 7
    itTGA = 8
    itPSD = 9
    itPSB = 10
    itEPS = 11
    itPS = 12
    itAI = 13
End Enum

'Private member variables
Private m_Width As Long
Private m_Height As Long
Private m_Depth As Byte
Private m_ImageType As eImageType

'Object PROPERTIES

Public Property Get Width() As Long
    Width = m_Width
End Property

Public Property Get Height() As Long
    Height = m_Height
End Property

Public Property Get Depth() As Byte
    Depth = m_Depth
End Property

Public Property Get ImageType() As eImageType
    ImageType = m_ImageType
End Property

'Routine to read the image information. This is the only object METHOD.
Public Sub ReadImageInfo(sFileName As String)

    'Byte array buffer to store part of the file
    Dim bBuf(BUFFERSIZE) As Byte
    
    Dim j, k As Integer 'Loop variables.
    Dim iFN, endian As Integer  'Open file number and Big/Little endian flag.
    Dim dta_link(10) As Integer 'An array to define the sizes in bytes of the various data types.
    
    dta_link(1) = 1: dta_link(2) = 1: dta_link(3) = 2: dta_link(4) = 4: dta_link(5) = 8
    dta_link(6) = 0: dta_link(7) = 1: dta_link(8) = 8: dta_link(9) = 4: dta_link(10) = 8
    
    Dim offset, num_tag, t_off, tv As Long  'TIF offset, number of Tags, Tag offset and Tag value.
    Dim d_typ, d_sze, d_val, d_off As Long  'IFD Data TYPE, data SIZE, data VALUE and data OFFSET.
    
    Dim txt As String
    
    'Set all properties to default values
    m_Width = 0
    m_Height = 0
    m_Depth = 0
    m_ImageType = itUNKNOWN
    
    'Here we will load the first part of a file into a byte array.
    'The amount of the file stored here depends on the BUFFERSIZE constant.
    
    iFN = FreeFile                      'Get next available file number and
    Open sFileName For Binary As iFN    'open the selected file for binary.
    Get #iFN, 1, bBuf()     'Read the data into the byte buffer and
    Close iFN               'close the file.

    'CHECK FOR ICONS
    If bBuf(0) = 0 And bBuf(2) = 1 Then
        m_ImageType = itICO 'This is an ICON, so
        m_Depth = bBuf(4)   'store the NUMBER OF IMAGES as the DEPTH.
        'It would be possible to expand this so as to list the various file sizes.
Exit Sub 'ICON
    End If

    'CHECK FOR .TIF
    If bBuf(2) = 42 Then
        m_ImageType = itTIFF 'This is an TIF, so
        'set a flag to indicate which 'endian' format the files uses.
        If bBuf(0) = 77 Then 'this is the Big-endian format.
            endian = 0  'Big-endian flag.
        Else
            endian = 1  'Little-endian flag.
        End If
        
        offset = BigMult(bBuf(4), bBuf(5), bBuf(6), bBuf(7), endian)    'Store the IFD offset.
        If offset < BUFFERSIZE Then 'the buffer is big enough, so
            num_tag = Mult(bBuf(offset), bBuf(offset + 1), endian)  'store the number of tags.

            For j = 0 To num_tag - 1    'Check each tag.
                t_off = offset + 2 + 12 * j
                If t_off < BUFFERSIZE Then 'the buffer is big enough, so
                    tv = Mult(bBuf(t_off), bBuf(t_off + 1), endian) 'store the Tag value.
                    Select Case tv  'Use a Case structure to find the Tags we want.
                        Case 256 'is image WIDTH.
                            m_Width = BigMult(bBuf(t_off + 8), bBuf(t_off + 9), bBuf(t_off + 10), bBuf(t_off + 11), endian) 'Store the image WIDTH.
                        Case 257 'is image HEIGHT.
                            m_Height = BigMult(bBuf(t_off + 8), bBuf(t_off + 9), bBuf(t_off + 10), bBuf(t_off + 11), endian) 'Store the image Height.
                        Case 258 'is bits/sample.
                            'Find out if the actual value is here or if it's a pointer.
                            d_typ = Mult(bBuf(t_off + 2), bBuf(t_off + 3), endian) 'Store the DATA TYPE.
                            d_sze = dta_link(d_typ)    'Store the actual data SIZE and
                            d_val = BigMult(bBuf(t_off + 4), bBuf(t_off + 5), bBuf(t_off + 6), bBuf(t_off + 7), endian)     'the number of values.
                            If d_sze * d_val <= 4 Then 'this data fits in the IDF, so
                                m_Depth = BigMult(bBuf(t_off + 8), bBuf(t_off + 9), bBuf(t_off + 10), bBuf(t_off + 11), endian) 'store the data.
                            Else    'Otherwise, it's an offset to the actual data.
                                d_off = BigMult(bBuf(t_off + 8), bBuf(t_off + 9), bBuf(t_off + 10), bBuf(t_off + 11), endian) 'store the data OFFSET from the start.
                                m_Depth = 0 'Initialise the DEPTH value.
                                For k = 0 To d_val - 1  'Loop for the number of data items,
                                    m_Depth = m_Depth + Mult(bBuf(d_off + 2 * k), bBuf(d_off + 2 * k + 1), endian)  'adding in each value.
                                Next
                            End If
                    End Select
                Else
                    MsgBox "A larger Buffer is required to deal with this file."
                End If
            Next
        Else
            MsgBox "A larger Buffer is required to deal with this file."
        End If
Exit Sub 'TIF
    End If
    
    'CHECK FOR .PCX
    If bBuf(0) = 10 And bBuf(2) = 1 Then 'this is a PCX file, so
        m_Depth = bBuf(3) * bBuf(65) 'Store the DEPTH, (Bits/pixel/bit plane x number of bit planes).
        m_Width = Mult(bBuf(8), bBuf(9), 1) - Mult(bBuf(4), bBuf(5), 1) + 1     'Data is stored using
        m_Height = Mult(bBuf(10), bBuf(11), 1) - Mult(bBuf(6), bBuf(7), 1) + 1  'Little-endian format.
Exit Sub 'PCX
    End If
    
    'CHECK FOR .PNG
    If bBuf(0) = 137 And bBuf(1) = 80 And bBuf(2) = 78 Then 'this is a PNG file, so
        m_ImageType = itPNG
        'Get bit depth
        Select Case bBuf(25)
            Case 0 'is Greyscale
                m_Depth = bBuf(24)
            Case 2 'is RGB encoded
                m_Depth = bBuf(24) * 3
            Case 3 'is Palette based, 8 bpp
                m_Depth = 8
            Case 4 'is Greyscale with alpha
                m_Depth = bBuf(24) * 2
            Case 6 'is RGB encoded with alpha
                m_Depth = bBuf(24) * 4
            Case Else
            'This value is outside of it's normal range, so we'll
            'assume that this is not a valid file at this stage.
                m_ImageType = itUNKNOWN
        End Select
        
        If m_ImageType Then 'the image is valid,so
            m_Width = Mult(bBuf(18), bBuf(19), 0)   'Get the width
            m_Height = Mult(bBuf(22), bBuf(23), 0)  'Get the height
Exit Sub 'PNG
        End If
    End If
    
    'CHECK FOR .GIF
    If bBuf(0) = 71 And bBuf(1) = 73 And bBuf(2) = 70 Then 'this is a GIF file
        m_ImageType = itGIF
        m_Width = Mult(bBuf(6), bBuf(7), 1)     'Get the width
        m_Height = Mult(bBuf(8), bBuf(9), 1)    'Get the height
        m_Depth = (bBuf(10) And 7) + 1          'Get bit depth
Exit Sub 'GIF
    End If
    
    If bBuf(0) = 66 And bBuf(1) = 77 Then 'this is a BMP file
        m_ImageType = itBMP
        m_Width = Mult(bBuf(18), bBuf(19), 1)   'Get the width
        m_Height = Mult(bBuf(22), bBuf(23), 1)  'Get the height
        m_Depth = bBuf(28)                      'Get bit depth
Exit Sub 'BMP
    End If
    
    'CHECK FOR .PSD OR .PSB
    txt = text_reader(sFileName, 0, 4)    'Read the file header text.
    If txt = psb_sig Then 'it's either a .PSB or a .PSD
        Select Case Mult(bBuf(4), bBuf(5), 0)   'The header data is Big-endian.
            Case 1 'is a .PSD, so
                m_ImageType = itPSD
            Case 2 'is a .PSB, so
                m_ImageType = itPSB
            Case Else 'it's an error.
                MsgBox "Bad Version number!"
                Exit Sub
        End Select
        m_Width = BigMult(bBuf(18), bBuf(19), bBuf(20), bBuf(21), 0)
        m_Height = BigMult(bBuf(14), bBuf(15), bBuf(16), bBuf(17), 0)
        m_Depth = Mult(bBuf(12), bBuf(13), 0) * Mult(bBuf(22), bBuf(23), 0)
Exit Sub
    End If
    
    'CHECK FOR .EPS, .PS and .AI
    'NB it's possible to have vastly non-standard versions of these files which won't
    'be detected by the following tests.
    If bBuf(0) = 197 And bBuf(1) = 208 And bBuf(2) = 211 And bBuf(3) = 198 Then 'this is an
        m_ImageType = itEPS                                                     '.EPS file
    Else    'Lets check for .PS or .AI
        iFN = FreeFile                      'Get next available file number and
        Open sFileName For Input As iFN     'open the file for input.
            Input #iFN, txt
            If Left(txt, 10) = adobe_sig Then 'it's either a .PS or .AI file.
                Do Until EOF(iFN) Or Left(txt, 9) = creator_tag
                    Input #iFN, txt
                Loop
                If Not EOF(iFN) Then 'this has a 'Creator' tag, so check for Illustrator.
                    If Mid(txt, 12, 17) = ai_sig Then 'this is an .AI file.
                        m_ImageType = itAI
                    Else 'We will assume it's a .PS
                        m_ImageType = itPS
                    End If
                End If
            End If
        Close #iFN
    End If
    
    'In all cases, now look for the Bounding Box line, (it's neccessary to start again
    'because there's no prescribed order for the items.
    Dim p1, p2 As Integer
    Dim sk As Long
    Dim sze(3) As Long
    
    sk = 1  'Set the default 'Seek' value.
    'The first part of an .EPS file can't be read in a line at a time.
    If m_ImageType = itEPS Then 'find the start of the EPS header section, (first '%%').
        For j = 0 To BUFFERSIZE - 1
            If Chr(bBuf(j)) + Chr(bBuf(j + 1)) = comm_tag Then 'this is the start of the
                sk = j  'Header area, so set the 'Seek' value to the current position and
                j = BUFFERSIZE - 1  'terminate the loop.
            End If
        Next
    End If
    
    iFN = FreeFile                      'Get next available file number and
    Open sFileName For Input As iFN     'open the file for input.
        Seek #iFN, sk   'Set the file pointer.
        Do Until EOF(iFN) Or Left(txt, 13) = bb_tag  'Look for the BoundingBox tag.
            Input #iFN, txt
        Loop
        If Not EOF(iFN) Then 'this is the BoundingBox line, so get the dimensions.
            txt = Trim(Right(txt, Len(txt) - 15))   'Cut the values out of the string.
            p1 = 1: p2 = 0  'Initialise the pointers.
            For j = 1 To Len(txt)   'Loop through the string.
                If Mid(txt, j, 1) = " " Then 'This is a space, so
                    sze(p2) = Val(Mid(txt, p1, j - p1)) 'Cut out the value.
                    p1 = j + 1  'Increment the 'start' pointer and
                    p2 = p2 + 1 'the array pointer.
                End If
            Next
            sze(p2) = Val(Mid(txt, p1, j - p1)) 'Store the last item.
        End If
    Close #iFN
    
    m_Width = sze(2) - sze(0)   'Store the Width and
    m_Height = sze(3) - sze(1)  'Height of the graphic.
    
    'NB Due to wide variations in structure of .EPS, .PS and .AI files, it's not worth
    'trying to find the colour depth.
    If m_Width > 0 Then Exit Sub
    
    If m_ImageType = itUNKNOWN Then
    'Let's first see if it's a TGA
        txt = text_reader(sFileName, FileLen(sFileName) - 17, 16)   'Read the file footer.
        If txt = tga_sig Then 'this is a v2 TGA file.
        'NB Even if there isn't a match to the TGA signature, it could be a TGA
        'v1 file for which I can't find a definite identifier!!
            m_ImageType = itTGA
            m_Width = Mult(bBuf(12), bBuf(13), 1)   'Store the WIDTH, (TGAs are Little-endian).
            m_Height = Mult(bBuf(14), bBuf(15), 1)  'Store the HEIGHT.
            m_Depth = bBuf(16)  'Store the DEPTH.
Exit Sub 'TGA
        End If
        
    'If the file is not a .TGA then
    'check to see if it's a JPEG.
        Dim lPos As Long
        
        Do
        'Loop through looking for the byte sequence FF,D8,FF
        'which marks the begining of a JPEG file
        'lPos will be left at the postion of the start
            If (bBuf(lPos) = &HFF And bBuf(lPos + 1) = &HD8 _
                 And bBuf(lPos + 2) = &HFF) _
                 Or (lPos >= BUFFERSIZE - 10) Then Exit Do
            lPos = lPos + 1 'move the pointer up
        Loop 'and continue
        
        lPos = lPos + 2
        If lPos >= BUFFERSIZE - 10 Then
            MsgBox "A larger Buffer is required to deal with this file."
            Exit Sub
        End If
        
        Do
        'Loop through the markers until we find the one
        'starting with FF,C0 which is the block containing the
        'image information
            Do
            ' loop until we find the beginning of the next marker
                If bBuf(lPos) = &HFF And bBuf(lPos + 1) _
                    <> &HFF Then Exit Do
                lPos = lPos + 1
                If lPos >= BUFFERSIZE - 10 Then
                    MsgBox "A larger Buffer is required to deal with this file."
                    Exit Sub
                End If
            Loop
            
            lPos = lPos + 1 'Move pointer up
            
            Select Case bBuf(lPos)
                Case &HC0 To &HC3, &HC5 To &HC7, &HC9 To &HCB, &HCD To &HCF
                ' we found the right block
                Exit Do
            End Select
            
            ' otherwise keep looking
            lPos = lPos + Mult(bBuf(lPos + 1), bBuf(lPos + 2), 0)
            
            If lPos >= BUFFERSIZE - 10 Then
                MsgBox "A larger Buffer is required to deal with this file."
                Exit Sub
            End If
        Loop
        ' If we've got this far, it is a JPEG and we are ready to read the information.
        m_ImageType = itJPEG
        m_Height = Mult(bBuf(lPos + 4), bBuf(lPos + 5), 0)  'Store the height
        m_Width = Mult(bBuf(lPos + 6), bBuf(lPos + 7), 0)   'Store the width
        m_Depth = bBuf(lPos + 8) * 8    'Store the color depth
    End If
    
End Sub

'Routine for TWO byte multiplication with an 'Endian' flag.
'Procedure name:    Mult(b1 As Byte, b2 As Byte, flg As Integer) As Long
'Parameters:        b1;     the first byte,
'                   b2;     the second byte.
'                   flg;    the Endian flag, 0 = Big-endian, 1 = Little-endian.

Private Function Mult(b1 As Byte, b2 As Byte, flg As Integer) As Long

    If flg = 1 Then 'this is Little-endian, so
        Mult = b1 + (b2 * CLng(256))    'the first byte is the least significant.
    Else                                'Otherwise,
        Mult = b2 + (b1 * CLng(256))    'the first byte is the most signicicant.
    End If
    
End Function

'Routine for FOUR byte multiplication with an 'Endian' flag.
'Procedure name:    BigMult(b1 As Byte, b2 As Byte, b3 As Byte, b4 As Byte, flg As Integer) As Long
'Parameters:        b1;     the first byte,
'                   b2;     the second byte,
'                   b3;     the third byte,
'                   b4;     the fourth byte.
'                   flg;    the Endian flag, 0 = Big-endian, 1 = Little-endian.

Private Function BigMult(b1 As Byte, b2 As Byte, b3 As Byte, b4 As Byte, flg As Integer) As Long

    If flg = 1 Then
        BigMult = b1 + (b2 * CLng(256)) + (b3 * CLng(256) * CLng(256)) + (b4 * CLng(256) * CLng(256) * CLng(256))
    Else
        BigMult = b4 + (b3 * CLng(256)) + (b2 * CLng(256) * CLng(256)) + (b1 * CLng(256) * CLng(256) * CLng(256))
    End If
    
End Function

'Routine to read text from a file Header or Footer.
'Function name: text_reader(flnme, strt, ln)
'Parameter:     flnme;  file name.
'               strt;   starting position in file,
'               ln;     number of bytes to be read.

Private Function text_reader(flnme, strt, ln)

    Dim bt As Byte
    Dim fn, j As Integer
    Dim tx As String
    
    tx = ""     'Initialise the output string.
    
    fn = FreeFile               'Get next available file number and
    Open flnme For Binary As fn 'open the selected file for binary.
        If strt > 0 Then    'If this doesn't start at the begining of the file,
            Seek #fn, strt  'set the data pointer to the start of the text.
        End If
        
        For j = 1 To ln
            Get #fn, , bt       'Read in the bytes and
            tx = tx + Chr(bt)   'assemble them into a string.
        Next
    Close #fn
    
    text_reader = tx 'Return the string.
    
End Function
