VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "about_64"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False

'CLASS  ABOUT DISPLAY, 'about_64'.
'Requires a form, 'About', and two graphics, f_ul_U.gif and f_ul_D.gif in the main
'program for Up and Down images for the Close Form button.
'The public constant, 'v_dte', used in the version display must also be defined in the
'main program.

'Data for the display is taken from the project properties as detailed below.
'App.ProductName:                   Title
'App.Major+App.Minor+App.Revision:  Version
'App.Description:                   Description
'App.Comments:                      Comments
'App.LegalCopyright:                Copyright
'App.LegalTrademark:                Contact e-mail address.

'There are two forms of layout; one with a graphic and logo, the other
'with just a logo.

'This version edited to display memory use and allocations for a 64 bit system.

' Philip Bolt, 2006, 2013
'Last updated: 22/9/13

Option Explicit
Option Compare Text

Private f_top As Integer            'Form Top position.
Private f_left As Integer           'Form Left position.

Private back_colour As Long         'Form background colour.
Private text_colour As Long         'Form foreground, (text), colour.

Private IL1() As String             'ImageList1 image source data.
Private app_path As String          'The application path.

Private setup As Boolean            'Object created flag.
Private defined As Boolean          'About Form defined flag.

Private ctrl() As Object            'Form control objects.

Private Type INT64                  'User defined 8 byte integer,
   LoPart As Long                   'LOW 4 bytes,
   HiPart As Long                   'HIGH 4 bytes.
End Type

Private Type MEMORYSTATUSEX         'User defined memory type.
   dwLength As Long
   dwMemoryLoad As Long
   ulTotalPhys As INT64
   ulAvailPhys As INT64
   ulTotalPageFile As INT64
   ulAvailPageFile As INT64
   ulTotalVirtual As INT64
   ulAvailVirtual As INT64
   ulAvailExtendedVirtual As INT64
End Type

Private Declare Sub GlobalMemoryStatusEx Lib "kernel32" (lpBuffer As MEMORYSTATUSEX)

'Object constructor.
'Run when the object is created.

Private Sub Class_Initialize()

    If Not setup Then
        set_up
        setup = True
    End If
    
End Sub

'Procedure name:    Class_Terminate()
'Run when a page is terminated.

Private Sub Class_Terminate()

    Unload About
    Set About = Nothing
 
End Sub

'Routine to set up the variables and defaults of the About form when the object is
'created.
'Procedure name:    set_up

Private Sub set_up()

    Dim j As Integer
    Dim img As Object
    
    app_path = App.Path + "\"   'Store the application path.
    
    ReDim IL1(1, 1) 'Dimension the ImageList data array.
    IL1(0, 0) = "f_ul_U.gif": IL1(1, 0) = "f_ul_D.gif"
    IL1(0, 1) = "Up": IL1(1, 1) = "Down"
    
    ReDim ctrl(14)  'Dimension the control array.
    
    Set ctrl(0) = About.Frame1(0)       'The top frame.
    Set ctrl(1) = About.Frame1(1)       'The middle frame.
    Set ctrl(2) = About.Frame1(2)       'The lower frame.
    
    Set ctrl(3) = About.title_lbl(0)    'The title
    Set ctrl(4) = About.title_lbl(1)    'The version
    Set ctrl(5) = About.title_lbl(2)    'Description
    Set ctrl(6) = About.title_lbl(3)    'Comments
    
    Set ctrl(7) = About.mem_lbl         'Memory data.
    
    Set ctrl(8) = About.make_lbl(0)     'Company name.
    Set ctrl(9) = About.make_lbl(1)     'Copyright.
    Set ctrl(10) = About.make_lbl(2)    'Contact address.
    
    Set ctrl(11) = About.Image1         'Graphic.
    Set ctrl(12) = About.Picture2       'Logo.
    
    Set ctrl(13) = About.Image2(0)      'The Close Form button.
    
    Set ctrl(14) = About.ImageList1     'The Up/Down images ImageList.
    
    For j = 0 To 1  'Load ImageList1 with the Up/Down images.
        Set img = ctrl(14).ListImages.Add(j + 1, IL1(j, 1), LoadPicture(app_path + "graphics/" + IL1(j, 0)))
    Next
    'Load the Form Unload UP image into the Image Box as the default.
    ctrl(13).Picture = ctrl(14).ListImages(1).Picture
    
    'Set default position.
    f_top = 1000
    f_left = 10000
    
    'Set default colours
    back_colour = &HC0C0C0      'Form background colour.
    text_colour = 0             'Form foreground, (text), colour.

    defined = False             'Clear the defined flag.
    
End Sub

'Routine to create the About form for the application.
'Procedure name:    create_About(logo As String, Optional b_c As Long = -1,
'                        Optional f_c As Long = -1,
'                        Optional tp As Integer = -1, Optional lf As Integer = -1,
'                        Optional grfic As String = "", Optional g_rat As Single = 1)

'If the optional values are missed, the stored defaults are used.

'Parameters:        logo;   logo graphic file name,
'                   b_c;    Background colour of form, etc.
'                   f_c;    Foreground, (text), colour,
'                   tp;     Form Top position,
'                   lf;     Form Left position,
'                   grfic;  Main graphic file name,
'                   g_rat;  the graphic ratio, (W:H).

Public Sub create_About(logo As String, Optional b_c As Long = -1, _
                        Optional f_c As Long = -1, _
                        Optional tp As Integer = -1, Optional lf As Integer = -1, _
                        Optional grfic As String = "", Optional g_rat As Single = 1)
 
    If Not defined Then
        'Check if the defaults are to be changed.
        If b_c > -1 Then        'Set background colour.
            back_colour = b_c
        End If
    
        If f_c > -1 Then        'Set text colour.
            text_colour = f_c
        End If
    
        If tp > -1 Then         'Set Top position
            f_top = tp
        End If
    
        If lf > -1 Then         'Set Left position.
            f_left = lf
        End If
    
        lay_out grfic, g_rat, logo  'Lay out the form.
        
        'THE 'defined' FLAG IS COMMENTED OUT ONLY FOR THIS DEMO.
        'IN ORDER TO ALLOW TWO About DISPLAYS.
        defined = True  'Flag that the form is defined, (only one allowed).
    End If
    
End Sub

'Routine to layout the controls on the form taking into account the amount of text
'and the presence or absence of a graphic.
'Procedure name:    lay_out(gr, lgo)
'Parameter:         gr;     the graphic file name, ("" = no graphic),
'                   rat;    the graphic ratio, (W:H), defaults to 1,
'                   lgo;    the logo file name.

Private Sub lay_out(gr, rat, lgo)

    Dim j, f_ht, f_wd, tp, c_wd, c_ht, l_off As Integer
    Dim mem_txt, desc, cmnt, tpm, pam As String
    
    set_About       'Set up the About form colours, etc.
    
    f_wd = 4200     'Define the frame width and
    tp = 1000       'description Top.
    
    desc = App.FileDescription  'See if there is a description.
    If desc = "" Then           'If not,
        ctrl(5).Height = 0      'shrink the Label and
        ctrl(5).Visible = False 'hide it.
    Else                        'Otherwise,
        With ctrl(5)
            .Height = get_ht(desc, f_wd - 200)  'get the required height for the text.
            .Top = tp                           'Set the top.
            .Caption = desc                     'Add the text and
            .Visible = True                     'show the Label.
        End With
        tp = tp + ctrl(5).Height + 200          'Increment the 'top' value.
    End If

    cmnt = App.Comments         'See if there is a comment.
    If cmnt = "" Then           'If not,
        ctrl(6).Height = 0      'shrink the Label and
        ctrl(6).Visible = False 'hide it.
    Else                        'Otherwise,
        With ctrl(6)
            .Height = get_ht(cmnt, f_wd - 200)  'Get the height needed for the box.
            .Top = tp                           'Set the top.
            .Caption = cmnt                     'Add the text and
            .Visible = True                     'show the Label.
        End With
        tp = tp + ctrl(6).Height + 200          'Increment the 'top' value.
    End If
 
    ctrl(0).Height = tp + 200   'Set the height of the upper frame.
 
    f_ht = 0                    'Initialise the form height.
    For j = 0 To 2              'Set each frame width.
        With ctrl(j)
            .Width = f_wd
            If j = 0 Then
                .Top = 300
            Else
                .Top = ctrl(j - 1).Height + ctrl(j - 1).Top + 300
            End If
        End With
        f_ht = f_ht + ctrl(j).Height
    Next
 
    If gr = "" Then
        ctrl(11).Visible = False    'Hide the Image box,
        f_wd = ctrl(0).Width + 800  'set the form width and
        l_off = 0                   'zero the Frame Left offset.
    Else
        With ctrl(11)
            .Top = 0                            'Position the Image box
            .Left = 0                           'and
            .Height = f_ht + 4 * 400            'set the height,
            .Width = .Height * rat              'width and
            .Picture = LoadPicture(app_path + gr) 'load the graphic.
            .Visible = True
        End With
        f_wd = ctrl(0).Width + ctrl(11).Width + 800 'Set the form width and
        l_off = ctrl(11).Width                      'the Frame Left offset value.
    End If
    
    With About                      'Set the
        .Width = f_wd               'width and
        .Height = f_ht + 4 * 400    'height of the form.
    End With
    
    For j = 0 To 2                  'The Frame Left position can only be set
        ctrl(j).Left = l_off + 400  'after the graphic size is known.
    Next
 
    For j = 3 To 6                  'Position the Frame1(0) Labels within the frame.
        With ctrl(j)
            .Left = 100
            .Width = ctrl(0).Width - 200
        End With
    Next
    
    With ctrl(7)                        'Set the memory data label
        .Left = 30                      'Left position and
        .Width = ctrl(1).Width - 100    'width.
    End With
    
    ctrl(3).Caption = App.ProductName   'Set the product name as the title
    ctrl(4).Caption = "Version " & App.Major & "." & App.Minor & "." & App.Revision & v_dte
    
    Dim udtMemStatEx As MEMORYSTATUSEX
    
    udtMemStatEx.dwLength = Len(udtMemStatEx)
    Call GlobalMemoryStatusEx(udtMemStatEx)
    
    tpm = NumberInKB(CLargeInt(udtMemStatEx.ulTotalPhys.LoPart, udtMemStatEx.ulTotalPhys.HiPart))
    pam = Round(CLargeInt(udtMemStatEx.ulAvailPhys.LoPart, udtMemStatEx.ulAvailPhys.HiPart) / (CLargeInt(udtMemStatEx.ulTotalPhys.LoPart, udtMemStatEx.ulTotalPhys.HiPart)) * 100)
    
    mem_txt = "Total memory = " + tpm + Chr(10) + "of which " + pam + "% is available."
    
    ctrl(7).Caption = mem_txt   'Add the memory usage text to the Label.
 
    ctrl(12).Picture = LoadPicture(app_path + lgo)  'Load the logo.
    
     For j = 8 To 10                            'Set the sizes
        With ctrl(j)                            'of the NAME,
            .Left = ctrl(12).Width + 200        'COPYRIGHT and
            .Width = ctrl(0).Width - .Left - 60 'CONTACT Labels.
        End With
    Next
    
    ctrl(8).Caption = App.CompanyName           'Add the NAME,
    ctrl(9).Caption = " " + App.LegalCopyright 'COPYRIGHT and
    ctrl(10).Caption = App.LegalTrademarks      'CONTACT text.
    
    With ctrl(13)                           'Set the positions for
        .Top = 60                           'the CLOSE Image Box.
        .Left = About.Width - .Width - 80
    End With
   
End Sub

'Routine to find the height of Comment and Description Labels.
'Function name: get_ht(txt, wdd)
'Parameters:    txt;    the text to be fitted in,
'               wdd;    the width of the Label.

Private Function get_ht(txt, wdd)

    Dim t_l As Integer
    
    t_l = About.TextWidth(txt) 'Store the width of the text.
    
    get_ht = (Int(t_l / wdd + 0.5) + 1) * About.TextHeight(txt)
 
 End Function

'Routine to set the colours of the form, text and button.
'together with the Top and Left values.
'Procedure name:    set_About

Private Sub set_About()

    Dim j As Integer

    About.BackColor = back_colour           'Form.
    
    For j = 0 To 2
        ctrl(j).BackColor = back_colour     'Frames.
        ctrl(j).ForeColor = text_colour
    Next

    For j = 3 To 6                          'Frame1(0) Labels.
         ctrl(j).BackColor = back_colour
         ctrl(j).ForeColor = text_colour
    Next
    
    ctrl(7).BackColor = back_colour         'Frame1(1) Label.
    ctrl(7).ForeColor = text_colour
    
    For j = 8 To 10                         'Frame1(2) Labels.
         ctrl(j).BackColor = back_colour
         ctrl(j).ForeColor = text_colour
    Next
    
    ctrl(12).BackColor = back_colour    'The Picture Boxes.
    
    With About          'Re-position the form.
        .Top = f_top
        .Left = f_left
    End With
    
End Sub

'This  converts the INT64 data type to a double
'Function name, CLargeInt(Lo As Long, Hi As Long)
'Parameters:    Lo; the lower 4 bytes as a LONG integer,
'               Hi; the HIGHER 4 bytes as a LONG integer.

Private Function CLargeInt(Lo As Long, Hi As Long) As Double

   Dim dblLo As Double
   Dim dblHi As Double

   If Lo < 0 Then
      dblLo = 2 ^ 32 + Lo
   Else
      dblLo = Lo
   End If

   If Hi < 0 Then
      dblHi = 2 ^ 32 + Hi
   Else
      dblHi = Hi
   End If

   CLargeInt = dblLo + dblHi * 2 ^ 32

End Function

'This converts memory numbers as type Currency to a string with byte, KB, MB or GB units.
'Function name: NumberInKB(ByVal vNumber As Currency)
'Parameter:     vNumber; the value to be converted.

Public Function NumberInKB(ByVal vNumber As Currency) As String
   
   Dim strReturn As String

   Select Case vNumber
      Case Is < 1024 ^ 1
         strReturn = CStr(vNumber) & " bytes"

      Case Is < 1024 ^ 2
         strReturn = CStr(Round(vNumber / 1024, 1)) & " KB"

      Case Is < 1024 ^ 3
         strReturn = CStr(Round(vNumber / 1024 ^ 2, 2)) & " MB"

      Case Is < 1024 ^ 4
         strReturn = CStr(Round(vNumber / 1024 ^ 3, 2)) & " GB"
   End Select

   NumberInKB = strReturn

End Function

