Attribute VB_Name = "LOT_ss"
'Modules to test various operations on ODS spreadsheets.
Option Explicit

'Private stck() As Integer           'Quick sort stack array.
Private idx() As Integer            'Quick sort index array.
Private keys() As Integer           'Mutiple field sorting, key fields array.
Private n_fld As Integer            'Number of KEY fields.
Private p_fld As Integer            'The previous field value, (Subscript).

'Routine to open an existing Calc workbook
'Parameter: fn, the file name.

Sub open_calc(fn)

    Dim j As Integer
    Dim arg()
    
    Set loCalc = loDesk.loadComponentFromURL(lo_path + fn, "_blank", 0, arg())
 
    n_shts = loCalc.sheets.Count    'Store the number of sheets in this book.
    
    ReDim loSheets(n_shts - 1)      'Redimension the sheets object array, [zero rooted].
    
    For j = 0 To n_shts - 1
        Set loSheets(j) = loCalc.getSheets().getByIndex(j)  'Define the set of Sheet objects for this book.
    Next

End Sub

'Routine to save a named Calc document.
'Procedure: save_calc(fn)
'Parameter: fn; file name.

Sub save_calc(fn)
 
    Dim arg()

    Call loCalc.storeToURL(lo_path + fn, arg())
     
End Sub

'Routine to set a sheet object as the active sheet.
'Procedure name:    MakeActiveSheet(sht)
'Parameter:         sht;    the sheet object concerned.

Sub MakeActiveSheet(sht)

    loCalc.CurrentController.activesheet = sht
    Set act_sht = loCalc.CurrentController.activesheet
    
End Sub

'Routine to RIGHT-JUSTIFY the contents of cell.
'Procedure name:    right_just(sht, c, r)
'Parameters:        sht;    the sheet concernedm
'                   c, r;   the column and row value of the Cell, [zero based].

Sub right_just(sht, c, r)
 
    Dim StyleFamilies As Object 'Style Families object
    Dim PageStyles As Object    'Page styles
    Dim CellStyles As Object    'Cell styles

    Dim cel, hj
    
    Set cel = sht.getCellByPosition(c, r)
    
    cel.HoriJustify = 3     '3 = RIGHT
    
End Sub

 
'A series of READ and WRITE Procedure/function tests.

Sub RW_data_test()

    Dim n_tst As Single
    Dim s_tst As String

    'FIRST SET OF TESTS INCLUDE THE SHEET ID WITHIN THE PROCEDURE OR FUNCTION.
    Wcell1 3, 5, 1, "text"      'Write data to a cell.
    Wcell1 3, 6, 1, 126.89      'Write data to a cell.
     
    s_tst = Rcell1(3, 5, 1)     'Read string data from a cell.
    MsgBox s_tst
    
    n_tst = Rcell1(3, 6, 1)     'Read string data from a cell.
    MsgBox n_tst
    
    'THE NEXT SET SELECTS A PARTICULAR SHEET AS THE ACTIVE SHEET AND ALL CELL REFERENCES ARE TO THAT SHEET.
    loCalc.getCurrentController.setActiveSheet loSheets(1)    'Make the second sheet active.

    Wcell2 3, 5, "new text"     'Write data to a cell.
    Wcell2 3, 6, 3.14712        'Write data to a cell.
     
    s_tst = Rcell2(3, 5)        'Read string data from a cell.
    MsgBox s_tst
    
    n_tst = Rcell2(3, 6)        'Read string data from a cell.
    MsgBox n_tst
   
End Sub

'Routine to WRITE data into a cell specified by c, r, (integers), sht, (Object index) and dta, (text)
'Parameters:    c;      column, (0 origin),
'               r;      row, (0 origin),
'               sht,    sheet object index,
'               dta,    data to be stored.

Sub Wcell1(r, c, sht, dta)

    Dim cel As Object
    
    Set cel = loSheets(sht).getCellByPosition(c, r) 'Define the required Cell.
    
    If IsNumeric(dta) Then  'NB a string of digits will generate TRUE!
        cel.Value = dta     'Store as numneric,
    Else                    'or
        cel.String = dta    'as a string
    End If
    
    Set cel = Nothing
    
End Sub

'Routine to READ data from a cell specified by c, r, (integers), sht, (Object index).
'Parameters:    c;      column, (0 origin),
'               r;      row, (0 origin),
'               sht,    sheet object index,

Function Rcell1(r, c, sht)

    Dim cel As Object
    Dim typ As Integer
    
    Set cel = loSheets(sht).getCellByPosition(c, r) 'Define the required Cell.
    
    typ = cel.getType()
    Select Case typ
        Case 0 'is EMPTY
            Rcell1 = ""
        Case 1 'is NUMERIC
            Rcell1 = cel.Value
        Case 2 'is STRING
            Rcell1 = cel.String
        Case 3 'is FORMULA
            Rcell1 = cel.formula 'Essentially, this will be a string.
    End Select

    Set cel = Nothing
    
End Function

'Routine to WRITE data into a cell specified by c, r, (integers),and dta.
'Parameters:    c;      column, (0 origin),
'               r;      row, (0 origin),

Sub Wcell2(c, r, dta)

    Dim cel, acts As Object
    
    Set acts = loCalc.CurrentController.activesheet 'Define  the ActiveSheet object and
    Set cel = acts.getCellByPosition(c, r)          'use it to define the required Cell.
    
    If IsNumeric(dta) Then 'NB a string of digits will generate TRUE!
        cel.Value = dta     'Store as numneric,
    Else                    'or
        cel.String = dta    'as a string
    End If
    
    Set cel = Nothing
    
End Sub

'Routine to READ data from a cell specified by c, r, (integers), and dta.
'Parameters:    c;      column, (0 origin),
'               r;      row, (0 origin),

Function Rcell2(r, c)

    Dim cel, acts As Object
    Dim typ As Integer
    
    Set acts = loCalc.CurrentController.activesheet 'Define  the ActiveSheet object and
    Set cel = acts.getCellByPosition(c, r)          'use it to define the required Cell.
    
    typ = cel.getType()
    Select Case typ
        Case 0 'is EMPTY
            Rcell2 = ""
        Case 1 'is NUMERIC
            Rcell2 = cel.Value
        Case 2 'is STRING
            Rcell2 = cel.String
        Case 3 'is FORMULA
            Rcell2 = cel.formula 'Essentially, this will be a string.
    End Select

    Set cel = Nothing
    
End Function

'Routine to carry out various range tests.

Sub range_test()

    Dim loRng, acts As Object
    
    loCalc.getCurrentController.setActiveSheet loSheets(1)  'Make the second sheet active and
    Set acts = loCalc.CurrentController.activesheet         'define  the ActiveSheet object.
    
    'SIMPLE TEST OF SETTING A RANGE TO A SINGLE COLOUR
    Set loRng = acts.getCellRangeByPosition(2, 1, 6, 13) '(c1, r1), (c2, r2)
    loRng.CellBackColor = RGB(0, 255, 0)    'NB The values are decoded as BLUE, GREEN, RED!
    
End Sub

'Routine to display various cell properties.
'Procedure name:    get_prop()

Sub get_prop()
    
    Dim acts, cel As Object
    
    'CELL PROPERTIES
    loCalc.getCurrentController.setActiveSheet loSheets(0)  'Make the first sheet active and
    Set acts = loCalc.CurrentController.activesheet         'define  the ActiveSheet object.
    Set cel = acts.getCellByPosition(9, 9)                  'Define the cell used for property checks.
   
    MsgBox "Background colour, " & split(cel.CellBackColor) 'RGB background colour.
   
    MsgBox "Text colour, " & split(cel.CharColor)   'RGB text colour.
    
    MsgBox "Font name, " & cel.CharFontName         'Font name
    
    MsgBox "Font weight, " & cel.CharWeight         'Font weight as a %, (150 = Bold)
    
    MsgBox "Point size, " & cel.CharHeight          'Point size.
    
    MsgBox "Posture(!), " & cel.CharPosture         'Returns  2 if italic, 0 if not.
    
    MsgBox "Underline, " & cel.CharUnderline        'Returns 1 if underlined, 0 if not.
    
    MsgBox "Overline, " & cel.CharOverline          'Returns 1 if overlined, 0 if not.
    
End Sub

'Function to convert a composite RGB value into its 3 sections.
'Function name: split(val)
'Parameter:     val;    the long colour value.

Function split(val)

    Dim div, vl, st As Double
    Dim vll As String
    
    div = 256
    vl = val
    vll = ""
    
    Do
        st = vl \ div
        vll = vll + CStr(vl - st * div) + "/"
        vl = st
    Loop Until vl < div
    vll = vll + CStr(vl)
    
    split = vll
    
End Function

'Routine to change the parameters of a cell.
'NB This should be done by including the parameters in a named style which can then be applied to the cell.
'Procedure name:    set_prop()

Sub set_prop()

     Dim acts, cel As Object
     
    'CELL PROPERTIES
    loCalc.getCurrentController.setActiveSheet loSheets(0)  'Make the first sheet active and
    Set acts = loCalc.CurrentController.activesheet         'define  the ActiveSheet object.
    
    Wcell2 6, 5, "new text"                                 'Write data to a cell.
    
    Set cel = acts.getCellByPosition(6, 5)                  'Define the cell to be used, (B6).
    cel.CharColor = RGB(255, 0, 0)  'BLUE!
    cel.CharWeight = 150
   
End Sub

'Routine to set cell colour.
'Procedure name:    colour_test()

Sub colour_test()

    Dim cel, acts As Object
    Dim r1, g1, b1 As Integer
    
    loCalc.getCurrentController.setActiveSheet loSheets(1)  'Make the first sheet active and
    Set acts = loCalc.CurrentController.activesheet         'define  the ActiveSheet object.
    
    Set cel = acts.getCellByPosition(2, 0)
    
    r1 = acts.getCellByPosition(0, 0).Value 'A1 - enter any number
    g1 = acts.getCellByPosition(0, 1).Value 'A2 - do
    b1 = acts.getCellByPosition(0, 2).Value 'A3 - do
    cel.CellBackColor = RGB(r1, g1, b1)

End Sub


'Routine to set either PAGE or CELL styles for a Calc book using a PRE_EXISTING style.
'The same concept can be used to apply style to a range object.

'Procedure name:    set_style(sn)
'Parameter:         sn; the Style name.

Sub set_style(sn)

    Dim StyleFamilies As Object 'Style Families object
    Dim PageStyles As Object    'Page styles
    Dim CellStyles As Object    'Cell styles
    Dim pStyle As Object        'Page style object for  modification.
    Dim cStyle As Object        'Cell style object for  modification.
    Dim cel, acts As Object     'Cell and Active sheet objects.
    
    loCalc.getCurrentController.setActiveSheet loSheets(0)  'Make the first sheet active and
    Set acts = loCalc.CurrentController.activesheet         'define  the ActiveSheet object and
     
    Set StyleFamilies = loCalc.StyleFamilies                'Store the Style Families,
    Set PageStyles = StyleFamilies.getByName("PageStyles")  'the Page styles array and
    Set CellStyles = StyleFamilies.getByName("CellStyles")  'the Cell styles array.
    
    Set cel = acts.getCellByPosition(2, 5)  'Select a cell and
    cel.CellStyle = sn                      'apply the named style.
    
End Sub

'Routine to test the Style creation routine.
'Procedure  name:   test_style()

Sub test_style()

    Dim sParm(7) As Variant
    
    sParm(0) = RGB(127, 0, 0)   'Text, Blue!
    sParm(1) = RGB(0, 0, 127)   'Background, Red!
    sParm(2) = "Georgia"        'Font name
    sParm(3) = 12               'Point size
    sParm(4) = 150              'Weight, 150 = Bold
    sParm(5) = 1                'Posture, 1 = Italic
    sParm(6) = 16               'Underline
    sParm(7) = 16               'Overline
    
    make_style "tester3", sParm()
    
End Sub

'Routine to create either PAGE or CELL styles for a Calc book based on the DEFAULT style.
'Procedure name:    make_style(sn, cn, parm() As Variant)
'Parameter:         sn; the Style name,

Sub make_style(sn, parm())

    Dim cn As String
    
    Dim StyleFamilies As Object 'Style Families object
    Dim PageStyles As Object    'Page styles
    Dim CellStyles As Object    'Cell styles
    Dim pStyle As Object        'Page style object for  modification.
    Dim cStyle As Object        'Cell style object for  modification.
    Dim cel, acts As Object     'Cell and Active sheet objects.
    Dim props
    
    loCalc.getCurrentController.setActiveSheet loSheets(0)  'Make the first sheet active and
    Set acts = loCalc.CurrentController.activesheet         'define  the ActiveSheet object and
    
    props = loCalc.getDocumentProperties()  'Define the document properties object and
    cn = props.title                       'store the basic file name.
     
    Set StyleFamilies = loCalc.StyleFamilies                'Store the Style Families,
    Set PageStyles = StyleFamilies.getByName("PageStyles")  'the Page styles array and
    Set CellStyles = StyleFamilies.getByName("CellStyles")  'the Cell styles array.
    
    Set cStyle = CellStyles.getByName("Default")    'Set the Style object to the DEFAULT style and
    cStyle.Name = sn                                'store it with the new name.

    'Set whichever parameters are required.
    If parm(0) <> "" Then cStyle.CharColor = parm(0)        'RGB notation, actually, B, G, R
    If parm(1) <> "" Then cStyle.CellBackColor = parm(1)    'RGB notation, actually, B, G, R
    If parm(2) <> "" Then cStyle.CharFontName = parm(2)     'As string
    If parm(3) <> "" Then cStyle.CharHeight = parm(3)       'Point size, as integer.
    If parm(4) <> "" Then cStyle.CharWeight = parm(4)       '% value, 100 = normal, etc.
    If parm(5) <> "" Then cStyle.CharPosture = parm(5)      'Italic = 2
    If parm(6) <> "" Then cStyle.CharUnderline = parm(6)    '1 for underline, 0 if not
    If parm(7) <> "" Then cStyle.CharOverline = parm(7)     '1 for underline, 0 if not
    
    'IN ACTUAL USE, IT WOULD BE NECESSARY TO SAVE THE FILE TO PRESERVE THE NEW STYLE.
    'save_calc cn    'Save the Calc workbook in order to save the style.
    
End Sub

'Routine to print a preselected range of cells to a named printer.
'Procedure: prnt_rnge(pr, rn)
'Parameters:    pr; name of the printer as string,
'               rn; the range object.

Sub prnt_rnge(pr, rn)

    Dim pt As Integer
    Dim sht_nme As String
    Dim PrintProperties(1) As Variant
   
    Set PrintProperties(0) = MakePropertyValue("Wait", "True")  'Define the 'Wait' parameter and
    Set PrintProperties(1) = MakePropertyValue("Name", pr)      'the printer to be used.
    
    loCalc.Printer = PrintProperties()          'Set the printer properties.
    loCalc.getCurrentController().Select (rn)   'THIS WORKS

    loCalc.getCurrentController().definePrintAreas (rn)
    
    Set PrintProperties(0) = MakePropertyValue("ToPoint", rn.absolutename)  'Set for the range and, [Page print would use, e.g, ("Pages", "1 - 3")]
    Set PrintProperties(1) = MakePropertyValue("CopyCount", 1)              'a single copy.
    
    CallByName loCalc, "print", VbMethod, PrintProperties() 'THIS STILL PRINTS WHOLE COLUMN
  
End Sub

'Routine to create a sequence of com.sun.star.beans.PropertyValues
'Function name: MakePropertyValue(pName, pValue)
'Parameters:    pName;  the property name as a string,
'               pValue; the associated value.

Public Function MakePropertyValue(pName, pValue) As Object
    
    Dim loStruct As Object
    
    Set loStruct = loSM.Bridge_GetStruct("com.sun.star.beans.PropertyValue")
    loStruct.Name = pName
    loStruct.Value = pValue
    Set MakePropertyValue = loStruct
    
End Function

'Routine to create a sequence of com.sun.star.util.SortField
'Function name: MakeSortField(sFld, sValue)
'Parameters:    sFld;  the Field name as a string,
'               sValue; the associated value.

Public Function MakeSortField(sFld, sValue) As Object
    
    Dim loStruct As Object
    
    Set loStruct = loSM.Bridge_GetStruct("com.sun.star.util.SortField")
    loStruct.Field = sFld
    loStruct.SortAscending = sValue
    Set MakeSortField = loStruct
    
End Function

'QUICK sort routine using a SINGLE key field.
'Procedure name:    quick_sort_SF(sht, c1, c2, kc, nm, ad)
'Parameters:        sht;    the sheet object,
'                   c1, c2; the first and last data columns,
'                   kc;     the key column, [assumed to be included bewteen c1 and c2],
'                   nm;     the number of sets of data, [assumed to start on row 1, coded 0].
'                   a_d;    the ASCENDING/DESCENDING flag, True = Ascending.

Public Sub quick_sort_SF(sht, c1, c2, kc, nm, a_d)

    Dim j, k, stk, b_lst, e_lst As Integer  'Stack pointer and values.
    Dim pt1, pt2 As Integer                 'Operational pointers.
    Dim stck() As Integer
    Dim strr As Variant                     'Temporary storage.
    Dim rnge As Object                      'Data range object.
     
    'THE FOLLOWING SECTION ISN'T NECESSARY. IT'S ONLY HERE SO THAT YOU CAN SEE THE DATA AREA CONCERNED.
    'YOU CAN JUST USE 'sht' INSTEAD OF 'act_sht' to load the data.
    MakeActiveSheet sht                                             'Make the data sheet active,
    Set rnge = act_sht.getCellRangeByPosition(c1, 0, c2, nm - 1)    'define the range and
    loCalc.getCurrentController().Select (rnge)                     'select it
    
    'IT'S POSSIBLE TO SKIP THE STORAGE ARRAY AND WORK DIRECTLY FROM THE WORKSHEET DATA,
    'BUT IT'S ABOUT THREE TIMES AS FAST TO USE AN ARRAY!
    ReDim stor(c2 - c1, nm - 1) 'Dimension the storage array.
     
    'LOAD STORAGE ARRAY.
    For j = c1 To c2
        For k = 0 To nm - 1
            stor(j - c1, k) = act_sht.getCellByPosition(j, k).String    'This will sort digits as strings!
        Next
    Next
    
    ReDim stck(nm * 1.5, 1)    'Dimension the stack array with 50% excess space.
    ReDim idx(nm - 1)          'Dimension the index array and
    For j = 0 To nm - 1        'populate it.
        idx(j) = j
    Next
    
    stk = 0 'Set the initial stack pointer.
 
    push 0, nm - 1, stk, stck() 'Push the initial values onto the stack.
  
    Do While stk <> 0
        pop b_lst, e_lst, stk, stck()   'Pop the stack values to give the beginning and end of list values for this block.
        pt1 = b_lst                     'Transfer the list limits to the operational pointers.
        pt2 = e_lst
         
        strr = idx(pt1)     'Store a data item index.
        'SKIP 'a_d' IF POSSIBLE SO AS TO REDUCE LOGICAL TESTS TO JUST 2 COMPARISONS RATHER THAN 5!
        Do While pt1 <> pt2
            Do While pt1 <> pt2 And ((stor(kc - 1, strr) <= stor(kc - 1, idx(pt2)) And a_d) Or (stor(kc - 1, strr) >= stor(kc - 1, idx(pt1)) And Not a_d)) 'Actual data comparison.
                pt2 = pt2 - 1 'Decrement pt2
            Loop 'While pt1 <> pt2, etc.
            idx(pt1) = idx(pt2) 'Transfer a record index, pt2 to pt1.
            Do While pt1 <> pt2 And ((stor(kc - 1, strr) >= stor(kc - 1, idx(pt1)) And a_d) Or (stor(kc - 1, strr) <= stor(kc - 1, idx(pt2)) And Not a_d)) 'Actual data comparison.
                pt1 = pt1 + 1 'Increment pt1
            Loop 'While pt1 <> pt2, etc.
            idx(pt2) = idx(pt1) 'Transfer a record index, pt1 to pt2.
        Loop 'While pt1 <> pt2
        
        idx(pt1) = strr 'Replace the stored record index.
      
        If b_lst <> pt1 Then 'push a new pair of values onto the stack.
            push b_lst, pt1 - 1, stk, stck()
        End If
        
        If e_lst <> pt1 Then 'push a new pair of values onto the stack.
            push pt1 + 1, e_lst, stk, stck()
        End If
    Loop 'While stk <> 0
    
    'RETURN THE SORTED DATA TO THE SHEET.
    For j = c1 To c2
        For k = 0 To nm - 1
            act_sht.getCellByPosition(j, k).String = stor(j - c1, idx(k))
        Next
    Next
    
End Sub

'Routine to sort a data array on multiple fields.
'The number of fields is given by 'n_fld'
 
'Procedure name:    Quick_sort_MF1(sht, c1, nc, ByRef ks() As Variant*, r1, nr, Optional a_d As Boolean = True)
'Parameters:        sht;    the sheet object,
'                   c1;     the first data column,
'                   nc;     the NUMBER of data columns,
'                   ks();   the key array, column numbers*,
'                   r1;     the FIRST row number,
'                   nr;     the NUMBER of rows, i.e. the number of items.
'                   a_d;    the ASCENDING/DESCENDING flag, True = Ascending.
'* The only reason that this is a Variant is that I use the 'Array' function to create it and this must be of type Variant.

Public Sub Quick_sort_MF1(sht, c1 As Integer, nc As Integer, ByRef ks() As Variant, r1 As Integer, nr As Integer, Optional a_d As Boolean = True)
    
    Dim j, k   As Integer   'Loop variables.
    Dim rnge As Object      'Data range object.

    'THE FOLLOWING SECTION ISN'T NECESSARY. IT'S ONLY HERE SO THAT YOU CAN SEE THE DATA AREA CONCERNED.
    'YOU CAN JUST USE 'sht' INSTEAD OF 'act_sht' to load the data.
    MakeActiveSheet sht                                             'Make the data sheet active,
    Set rnge = act_sht.getCellRangeByPosition(c1, 0, c1 + nc - 1, nr - 1)   'define the range and
    loCalc.getCurrentController().Select (rnge)                             'select it
    
    ReDim stor(nc - 1, nr - 1) 'Dimension the storage array using the zero subscripts.
     
    'LOAD STORAGE ARRAY.
    For j = c1 To c1 + nc - 1
        For k = r1 To r1 + nr - 1
            stor(j - c1, k - r1) = act_sht.getCellByPosition(j, k).String  'This will sort digits as strings!
        Next
    Next

    n_fld = UBound(ks)      'Find the upper limit of the KEY FIELD array.
    
    ReDim keys(n_fld), idx(nr - 1)
    For j = 0 To n_fld
        keys(j) = CInt(ks(j)) - c1   'Convert the KEY FIELD array to SUBSCRIPTS rather than actual COLUMNS.
    Next

    For j = 0 To nr - 1
        idx(j) = j          'Populate the index array.
    Next
    
    Quick_sort_MF2 r1, r1 + nr - 1, 0, a_d 'Initial sort call to the recursive routine..
 
    'RETURN THE SORTED DATA
    For j = c1 To c1 + nc - 1
        For k = 0 To r1 + nr - 1
            act_sht.getCellByPosition(j, k).String = stor(j - c1, idx(k))
        Next
    Next
  
End Sub

'Procedure name:    Quick_sort_MF2(strt As Integer, ndd As Integer, fd As Integer, Optional a_d As Boolean = True)
'Parameters:        strt & ndd; the first and last DATA ARRAY SUBSCRIPTS for the current block,
'                   fd;         the current key field, keys() subscript,
'                   a_d;        the Ascending/Descending sort flag. The optional default is True.

'This is used recursively to sort blocks of data on the prescribed fields.

Private Sub Quick_sort_MF2(strt As Integer, ndd As Integer, fd As Integer, Optional a_d As Boolean = True)

    Dim c_fld, frst, lst, cnt As Integer
    Dim vlu As Variant  'or DATA TYPE.
   
    If fd <= n_fld Then 'Check for the final field being exceeded.
        c_fld = keys(fd)    'Store the current key field, STORAGE array SUBSCRIPT.
        quick_sort_MF3 strt, ndd, fd, a_d   'Carry out the sort for this block of data.
        
        frst = strt                 'Store the start value,
        cnt = strt                  'set the array pointer and

        vlu = stor(c_fld, idx(cnt)) 'store the current data value.

        Do Until cnt = ndd          'Loop through this block of data.
            cnt = cnt + 1           'Increment the count
            If stor(c_fld, idx(cnt)) <> vlu Then 'there is a new value, so
                lst = cnt - 1                               'set the last value for this block and
                Quick_sort_MF2 (frst), (lst), (fd + 1), a_d 'sort the block on the next field.
                frst = cnt: vlu = stor(c_fld, idx(cnt))     'Reset the block pointers for the next
            End If                                          'block.
        Loop
        
        If cnt > frst Then 'there's still some data to be sorted, so
            Quick_sort_MF2 (frst), (cnt), (fd + 1), a_d 'sort the block.
        End If
    End If
  
End Sub

'Quick sort routine for multiple field sorts.
'This sorts a block of data defined by 'st' and 'nd' on the basis of the current field, 'fld'.
'This version sorts on the basis of an index array, 'idx()'.
'quick_srt
'Procedure name:    quick_sort_MF3(st, nd, fld, Optional a_d As Boolean = True)
'Parameters:        st, nd; the start and end array subscripts of the current block,
'                   fld;    the Storage  array KEY subscript,
'                   a_d;    the Ascending/Descending sort flag. The optional default is True.

Private Sub quick_sort_MF3(st, nd, fld, Optional a_d As Boolean = True)
 
    Dim c_fld, stk, b_lst, e_lst As Integer     'Stack pointer and values.
    Dim pt1, pt2 As Integer                     'Operational pointers.
    Dim strr As Variant                         'Temporary storage.
    Dim stack() As Integer                      'Stack array.
 
    c_fld = keys(fld)   'Store the array subscript of the current KEY field.

    ReDim stack(nd * 1.5 + 2, 1)    'Dimension the stack array, +2 is for small samples.
    
    stk = 0 'Set the initial stack pointer.
 
    push st, nd, stk, stack()   'Push the initial values onto the stack.
    
    Do While stk <> 0
        pop b_lst, e_lst, stk, stack()
       
        pt1 = b_lst             'Transfer the list limits to the operational pointers.
        pt2 = e_lst
        
        strr = idx(pt1)     'Store a data item index.
        'SKIP 'a_d' IF POSSIBLE SO AS TO REDUCE TESTS TO JUST 2 COMPARISON RATHER THAN 5!
        Do While pt1 <> pt2
            Do While pt1 <> pt2 And ((stor(c_fld, strr) <= stor(c_fld, idx(pt2)) And a_d) Or (stor(c_fld, strr) >= stor(c_fld, idx(pt1)) And Not a_d)) 'Actual data comparison.
                pt2 = pt2 - 1 'Decrement pt2
            Loop 'While pt1 <> pt2, etc.
            idx(pt1) = idx(pt2) 'Transfer a record index, pt2 to pt1.
            Do While pt1 <> pt2 And ((stor(c_fld, strr) >= stor(c_fld, idx(pt1)) And a_d) Or (stor(c_fld, strr) <= stor(c_fld, idx(pt2)) And Not a_d)) 'Actual data comparison.
                pt1 = pt1 + 1 'Increment pt1
            Loop 'While pt1 <> pt2, etc.
            idx(pt2) = idx(pt1) 'Transfer a record index, pt1 to pt2.
        Loop 'While pt1 <> pt2
        
        idx(pt1) = strr 'Replace the stored record index.
      
        If b_lst <> pt1 Then 'push a new pair of values onto the stack.
            push b_lst, pt1 - 1, stk, stack()
        End If
        
        If e_lst <> pt1 Then 'push a new pair of values onto the stack.
            push pt1 + 1, e_lst, stk, stack()
        End If
    Loop 'While stk <> 0
    
End Sub

'Routine to push values onto the Quicksort stack
'Procedure name:    push(n1, n2, ByRef stk, ByRef stkk), NB No brackets on the array parameter!
'Parameters:        n1, n2; the numbers to be added to the stack,
'                   stk;    the stack pointer.

Private Sub push(n1, n2, ByRef stk, ByRef stkk)

    stk = stk + 1           'Increment the Stack pointer and
    stkk(stk, 0) = n1      'store the values.
    stkk(stk, 1) = n2
    
End Sub

'Routine to pop values off the Quicksort stack
'Procedure name:    pop(ByRef v1, ByRef v2, ByRef stk, ByRef stkk()), NB No brackets on the array parameter!
'Parameters:        v1, v2; the numbers to be taken from the stack,
'                   stk;    the stack pointer.

Sub pop(ByRef v1, ByRef v2, ByRef stk, ByRef stkk)

    v1 = stkk(stk, 0)  'Read the values off the stack
    v2 = stkk(stk, 1)  'and
    stk = stk - 1       'decrement the stack pointer.
    
End Sub

'Routine to define a Cell address object.
'Function name: CreateCellAddress(sht, c, r)
'Parameters:    sht;    the sheet object,
'               c, the cell column, [zero based],
'               r, the cell row, [zero based].

Function CreateCellAddress(sht, c, r)

    Dim ca
    
    Set ca = loSM.Bridge_GetStruct("com.sun.star.table.CellAddress")
    
    ca.sheet = sht.RangeAddress.sheet   'Only the index of the sheet is needed.
    ca.Column = c
    ca.Row = r
    
    CreateCellAddress = ca
    
End Function

'Routine to define a Cell range address object.
'Function name: CreateCellRangeAddress(sht, sc, sr ,ec, er)
'Parameters:    sht;    the sheet object,
'               sc,     the start cell column, [TL, zero based],
'               sr,     the start cell row, [TL, zero based],
'               ec,     the end cell column, [BR, zero based],
'               er,     the end cell row, [br, zero based].

Function CreateCellRangeAddress(sht, sc, sr, ec, er)

    Dim cra
    
    Set cra = loSM.Bridge_GetStruct("com.sun.star.table.CellRangeAddress")
    
    cra.sheet = sht.RangeAddress.sheet  'Only the index of the sheet is needed.
    cra.StartColumn = sc
    cra.StartRow = sr
    cra.EndColumn = ec
    cra.EndRow = er
        
    CreateCellRangeAddress = cra
    
End Function

'Routine to move a block of cell data.
'Procedure name:    move_range(sht1, sc, sr, ec, er, sht2, c, r)
'Parameters:        sht1;   the sheet object holding the data,
'                   sc,     the start cell column, [TL, zero based],
'                   sr,     the start cell row, [TL, zero based],
'                   ec,     the end cell column, [BR, zero based],
'                   er,     the end cell row, [BR, zero based],
'                   sht2;   the sheet object to which the data is to be moved,
'                   c,      the cell column, [zero based],
'                   r,      the cell row, [zero based].

Sub move_range(sht1, sc, sr, ec, er, sht2, c, r)
 
    Dim rng
    Dim cel
     
    rng = CreateCellRangeAddress(sht1, sc, sr, ec, er)  'Define the data range to be moved and
    cel = CreateCellAddress(sht2, c, r)                 'the address of the TL corner cell for the move.
    
    sht1.moveRange cel, rng     'This will MOVE the data.
    'sht1.copyRange cel, rng    'This will COPY the data.
    
End Sub

'Routine to copy a block of cell data.
'Procedure name:    move_range(sht1, sc, sr, ec, er, sht2, c, r)
'Parameters:        sht1;   the sheet object holding the data,
'                   sc,     the start cell column, [TL, zero based],
'                   sr,     the start cell row, [TL, zero based],
'                   ec,     the end cell column, [BR, zero based],
'                   er,     the end cell row, [BR, zero based],
'                   sht2;   the sheet object to which the data is to be moved,
'                   c,      the cell column, [zero based],
'                   r,      the cell row, [zero based].

Sub copy_range(sht1, sc, sr, ec, er, sht2, c, r)
 
    Dim rng
    Dim cel
     
    rng = CreateCellRangeAddress(sht1, sc, sr, ec, er)  'Define the data range to be moved and
    cel = CreateCellAddress(sht2, c, r)                 'the address of the TL corner cell for the move.
    
    sht1.copyRange cel, rng    'This will COPY the data.
    
End Sub

'Routine to define a print area.
'Procedure name:    set_prnt_area(sht, c1, r1, c2, r2)
'Parameters:        sht;    the sheet object concerned,
'                   c1, r1; coords of upper left corner of area, [zero based],
'                   c2, r2; coords of lower right corner of area, [zero based].

Sub set_prnt_area(sht, c1, r1, c2, r2)
 
    Dim rng As Object
    Dim addr
    
    MakeActiveSheet sht     'Make the selected sheet Active. This is necessary as the area must be set on the active sheet.
    
    Set rng = sht.getCellRangeByPosition(c1, r1, c2, r2)    'Define the area.

    addr = rng.getRangeAddress()        'Store the range address and
    sht.setPrintAreas (Array(addr))     'use it to set the Print area.
    
End Sub

'Routine to abstract the sheet name from a Range object.
'Modification needed if more than one workbook used.
'Function name:     get_rng_sht(rng)
'Parameter:         rng;    the range concerned.

Function get_rng_sht(rng)

    Dim pt As Integer
    Dim r_nme, s_nme As String
    Dim grs
    
    r_nme = rng.absolutename        'Get the absolute name of the range,
    pt = InStr(r_nme, ".")          'find the first dot and
    s_nme = Mid(r_nme, 2, pt - 2)   'cut out the sheet name.
    
    MsgBox s_nme    'Only for illustration.
    
    grs = loCalc.sheets.getByName(s_nme)    'Get the sheet object from the name and
    get_rng_sht = grs                       'return it.
    
End Function

'Routine to define a print area on the active sheet.
'Procedure name:    set_prnt_area2(sht, c1, r1, c2, r2)
'Parameters:        rng;    the range concerned.

Sub set_prnt_area2(rng)

    Dim sht, addr
    
    sht = get_rng_sht(rng)              'Get the sheet object from the range,
    addr = rng.getRangeAddress()        'store the range address and
    sht.setPrintAreas (Array(addr))     'use it to set the Print area.
    
End Sub

'Routine to set the Window position and size.
'Procedure name:    Sub ResizeWindow(w, h, Optional tx As Integer = 0, Optional ty As Integer = 0)
'Parameters:        w;      the width,
'                   h;      the height,
'                   tx, ty; the Top-Left coordinates, defaulted to 0, 0 .
'
Sub ResizeW(w, h, Optional tx As Integer = 0, Optional ty As Integer = 0)

    Dim loFrame
    Dim loWindow
    Dim loRect
    Dim intHeight As Integer
    Dim intWidth  As Integer
    Dim intXPos As Integer
    Dim intYPos As Integer
    
    loFrame = loDesk.getCurrentFrame()
    loWindow = loFrame.getContainerWindow()
    loRect = loWindow.getPosSize()
   
    If tx = 0 Then
        intXPos = loRect.x
    Else
        intXPos = tx
    End If
    
    If ty = 0 Then
        intYPos = loRect.y
    Else
        intYPos = ty
    End If
  
    intHeight = h
    intWidth = w
    
    loWindow.setPosSize intXPos, intYPos, intWidth, intHeight, 15
   
End Sub

'Routine to read the window size of an open workbook, etc.
'Procedure name:    ReadW(wv, hv, txv, tyv),
'Parameters:        wv;         dummy for the return of the WIDTH,
'                   hv;         dummy for the return of the HEIGHT,
'                   txv, tyv;   dummies for the return of the TL coords.

Sub ReadW(wv, hv, txv, tyv)

    Dim loFrame
    Dim loWindow
    Dim loRect
    
    loFrame = loDesk.getCurrentFrame()
    loWindow = loFrame.getContainerWindow()
    loRect = loWindow.getPosSize()
   
    wv = loRect.Width
    hv = loRect.Height
    txv = loRect.x
    tyv = loRect.y
    
    'MsgBox wv & ", " & hv & ", " & txv & ", " & tyv    'Display of values for design use.
    
End Sub

'Routine to control zooming, unfortunately, the one set of data applies to the WHOLE document rather than a particular sheet.
'OPTIMAL = 0, the page content width (excluding margins) at the current selection is fitted into the view.
'PAGE_WIDTH = 1, the page width at the current selection is fitted  into the view.
'ENTIRE_PAGE = 2, a complete page of the document is fitted  into the view.
'BY_VALUE = 3, the zoom is relative and is to be set via the property ViewSettings::ZoomValue.
'PAGE_WIDTH_EXACT = 4, the page width at the current selection is fitted into the view, with the view ends exactly at the end of the page.
'See https://api.libreoffice.org/docs/idl/ref/namespacecom_1_1sun_1_1star_1_1view_1_1DocumentZoomType.html
'
'Procedure name:    zooom(optional tp as integer, optional vl as integer)
'Parameters:        tp; the TYPE of zoom, (see above),
'                   vl; the zoom value for BY_VALUE = 3

Sub zooom(Optional tp As Integer = -1, Optional vl As Integer = -1)
    
    If tp > -1 Then 'use this value to reset the Zoom type.
        loCalc.CurrentController.ZoomType = tp
    End If
    Select Case True
        Case tp = -1 'No parameter entered, so
            'keep the existing state and do nothing.
        Case (vl > -1) Or (tp = 3) 'Assume that BY_VALUE is intended and
            loCalc.CurrentController.ZoomType = 3   'set it.
        Case Else
            loCalc.CurrentController.ZoomType = tp  'Set the indicated type.
    End Select
    
    If vl > -1 Then 'use this value to reset the Zoom value.
        loCalc.CurrentController.ZoomValue = vl 'set the supplied value as a %.
    End If
    
End Sub

'Routine to insert a number of rows,
'(Columns similar).
'Procedure name:    insert_rows(sht, s, n)
'Parameters:        sht;    the sheet concerned,
'                   s;      the STARTING row
'                   n;      the NUMBER of rows to be inserted.
Sub insert_rows(sht, s, n)

    sht.Rows.insertByIndex s, n
     
End Sub

'Routine to delete a number of columns,
'(Rows similar).
'Procedure name:    delete_columns(sht, s, n)
'Parameters:        sht;    the sheet concerned,
'                   s;      the STARTING column
'                   n;      the NUMBER of columns to be deleted.
Sub delete_columns(sht, s, n)

    sht.Columns.removeByIndex s, n
    
End Sub

'Routine to hide, (and show), a set of columns.
'Procedure name:    hide_col(rng, flg),
'Parameters:        rng;    a range that defines the columns,
'                   flg;    a Boolean, True = show, False = Hide.

Sub hide_col(rng, flg)

    rng.Columns.IsVisible = flg
    
End Sub

'Routine to hide, (and show), a set of rows.
'Procedure name:    hide_row(rng, flg),
'Parameters:        rng;    a range that defines the columns,
'                   flg;    a Boolean, True = show, False = Hide.

Sub hide_row(rng, flg)

    rng.Rows.IsVisible = flg
    
End Sub

'Routine to fill a selected range with data included in the range.
'i.e. Fill Up/Down, Left/Right.
'The details of the parameters are given in LO+VB6.doc/ods
'This version is set up to copy formulae.
'Procedure name:    fil(r, d, Optional m As Integer = 0, Optional dm As Integer = 0, Optional stp As Integer = 0, Optional nd As Long = &H7FFFFF)
'Parameters:        r;      the range object,
'                   d;      the direction of fill, 0=Fill ROWS DOWN, 1=Fill COLUMNS RIGHT, 2= Fill ROWS UP, 3=Fill COLUMNS LEFT
'                   m;      the fill mode, default = fill without changing values, formulae copied, etc.
'                   dm;     the Date mode, default = add single day but see 'stp',
'                   stp;    the step value, default = zero,
'                   nd;     the end value, the upper limit for a sequence, deafult = large number.

Sub fil(r, d, Optional m As Integer = 0, Optional dm As Integer = 0, Optional stp As Integer = 0, Optional nd As Long = &H7FFFFF)
 
     r.fillSeries d, m, dm, stp, nd

End Sub

'Save an existing document as a PDF

Sub SaveAsPDF()

Dim OpenParam(1) As Object 'Parameters to open the workbook
Dim SaveParam(1) As Object 'Parameters to save the workbook

Set OpenParam(0) = MakePropertyValue("Hidden", True)  ' Open the file hidden
Set loCalc = loDesk.loadComponentFromURL(lo_path + "/test_bk.ods", "_blank", 0, OpenParam())

Set SaveParam(0) = MakePropertyValue("FilterName", "writer_pdf_Export") 'Save the file as a PDF.
Call loCalc.storeToURL(lo_path + "/test_bk.pdf", SaveParam())

loCalc.Close True

End Sub

'Routine to create a new file.
'Procedure name:    create_file()

Sub create_file()
 
    Dim args()

    Set loCalc = loDesk.loadComponentFromURL("private:factory/scalc", "_blank", 0, args())  'Create an untitled Calc file from a general template.
    Call loCalc.storeToURL(lo_path + "/new_file.ods", args())                               'Save the file with a specific name.
   
End Sub

