Attribute VB_Name = "LOT_main"

Option Explicit
Public c As Integer
Public n_shts As Integer    'Number of sheets in a Calc workbook.
Public n_bks As Integer     'Number of open workbooks.
Public ht  As Integer       'Screen height.
Public wd As Integer        'Screen width.
Public max_bks As Integer   'Maximum number of open books.
Public max_shts As Integer  'Maximum number of Worksheets.
Public k_f() As Integer     'The key field array for multiple field sorts.

Public vb_path As String    'Application path in VB format.
Public lo_path As String    'Application path in LO URL format.
Public v_dte As String      'The 'About' date.
Public stor() As String
Public lb() As String       'List Box data array.

Public str() As Variant     'The sort working array.

Public canceled As Boolean  'Operation 'Cancel' flag.
Public setup As Boolean     'Package set up flag.
Public loaded As Boolean    'Workbook loaded flag.

'OBJECTS
Public mnu As Object        'Menu object.
Public FSO                  'Basic scripting object.
Public frm As Object        'The form object.

'WORKBOOK OBJECTS
Public loSM As Object       'Global Service Manager object.
Public loDesk As Object     'Global LO Desktop object.
Public loCalc As Object     'Single file Calc object.
Public loSheets() As Object 'Object array for Calc sheets.
Public mCalc() As Variant   'Global Calc object array.
Public mSheets() As Object  'Oject array for Calc sheets.
Public act_sht As Object    'The Active sheet object.
Public rnge As Object       'A Range object.

'CLASS OBJECTS
Public cdc As New CDC_class     'Commom Dialog object.
Public ah As New about_64       'About Class object.

'ShellExecute function for use with Help system.
Private Declare Function ShellExecute Lib "shell32.dll" Alias "ShellExecuteA" _
                                           (ByVal hwnd As Long, _
                                            ByVal lpOperation As String, _
                                            ByVal lpFile As String, _
                                            ByVal lpParameters As String, _
                                            ByVal lpDirectory As String, _
                                            ByVal nShowCmd As Long) As Long

Sub set_up()

    Dim j As Integer
c = 0
    setup = False   'Clear the setup flag.
    
    Set loSM = CreateObject("com.sun.star.ServiceManager")          'Create an instance of LO Service Manager.
    Set loDesk = loSM.createInstance("com.sun.star.frame.Desktop")  'Create an LO Desktop.
    
    vb_path = App.Path & "\"        'Store the application path in vb format then
    lo_path = ConvertToUrl(vb_path) 'convert it to OL URL format.
    
    v_dte = date_modified()             'Store the date when the EXE file was last modified.

    ht = 0.9 * Screen.Height            'Get the usable screen height and
    wd = Screen.Width                   'the screen width.
    
    ah.create_About "graphics/PlasticAngel_fi.gif", &HC0CCD6, 0, , wd - 6000 'Set it up with the logo graphic
    Set frm = LOT_form
    
    Set mnu = frm.ce    'Define the 'Examples' menu object and
    mnu.Enabled = False 'disable it until a workbook is loaded.
    
    vb_path = App.Path & "\"        'Store the application path in vb format then
    lo_path = ConvertToUrl(vb_path) 'convert it to OL URL format.
   
    max_bks = 10        'Define the maximum number of Workbooks and
    max_shts = 20       'the maximum sheets/book.
    
    ReDim mCalc(max_bks, 1)             'Dimension the Workbook object array for the maximum size and
    ReDim mSheets(max_bks, max_shts)    'similarly for the sheets array.
    
    n_bks = 0       'Nunber of open workbooks.
    
    setup = True
 
 End Sub

'Converts a Ms Windows local pathname in URL
'
Public Function ConvertToUrl(strFile) As String

    Dim c_t_u As String
    
    c_t_u = strFile
    
    c_t_u = Replace(c_t_u, "\", "/")
    c_t_u = Replace(c_t_u, ":", "|")
    c_t_u = Replace(c_t_u, " ", "%20")
    c_t_u = "file:///" + c_t_u
    
    ConvertToUrl = c_t_u
    
End Function


'Routine to select and get the name of a  data file.
'Function name: select_file()

 Function select_file()
 
    Dim flgg As Long
    Dim fltr, ttl, f_n As String

    fltr = "LO  files(*.ODS)" & Chr$(0) & "*.ODS"
    flgg = cdlOFNNoChangeDir Or cdlOFNPathMustExist  'Set up the flags
    ttl = "LibreOffice with VB6: SELECT AN 'ODS' FILE"
 
    f_n = cdc.ShowOpen(LOT_form.hwnd, fltr, flgg, ttl, vb_path)

    select_file = f_n
    
End Function

'Routine to open an existing Calc workbook
'Parameter: fn, the file name.

Sub open_calc(fn)

    Dim j As Integer
    Dim arg()
    
    Set loCalc = loDesk.loadComponentFromURL(lo_path + fn, "_blank", 0, arg())
 
    n_shts = loCalc.sheets.Count    'Store the number of sheets in this book.
    
    ReDim loSheets(n_shts - 1)      'Redimension the sheets object array, [zero rooted].
    
    For j = 0 To n_shts - 1
        Set loSheets(j) = loCalc.getSheets().getByIndex(j)  'Define the set of Sheet objects for this book.
    Next

End Sub

'Routine to open a workbook.
'Procedure name:    open_wb()

Sub open_wb()
    
    Dim j As Integer
    Dim i_d, full_file_path As String
    Dim arg()
    Dim props
    
    canceled = False
    
     If loaded Then 'there is already an open workbook, so
        props = loCalc.getDocumentProperties()  'Define the document properties object and
        i_d = props.title                       'store the basic file name.
        Call loCalc.storeToURL(lo_path + i_d, arg())    'save it and
        loCalc.Close True       'close it.
        Set loCalc = Nothing    'Release its object  and
        For j = 0 To n_shts - 1         'the sheet objects
            Set loSheets(j) = Nothing   'for that workbook.
        Next
        
        loaded = False
    End If
    
    full_file_path = ConvertToUrl(select_file)    'Select the data file.
    
    If Not canceled Then
        Set loCalc = loDesk.loadComponentFromURL(full_file_path, "_blank", 0, arg())
        n_shts = loCalc.sheets.Count   'Store the number of sheets in this book.
        ReDim loSheets(n_shts - 1)
        For j = 0 To n_shts - 1
            Set loSheets(j) = loCalc.getSheets().getByIndex(j) 'Define the set of Sheet objects for this book.
        Next
        
        mnu.Enabled = True  'Enable the 'Routines' menu.
        
        loaded = True
    Else
        close_down loaded
    End If
    
End Sub

'Routine to open one of a series of workbooks.
'Procedure name:    open_multi_wb()

Sub open_multi_wb()
    
    Dim j As Integer
    Dim b_nme, full_file_path As String
    Dim arg()
    Dim props
    
    canceled = False
    
    full_file_path = ConvertToUrl(select_file)    'Select the data file.
    
    If Not canceled Then
        n_bks = n_bks + 1
        
        Set mCalc(n_bks, 0) = loDesk.loadComponentFromURL(full_file_path, "_blank", 0, arg())
         
        n_shts = mCalc(n_bks, 0).sheets.Count   'Store the number of sheets in this book.
    
        For j = 0 To n_shts - 1
            Set mSheets(n_bks, j) = mCalc(n_bks, 0).getSheets().getByIndex(j) 'Define the set of Sheet objects for this book.
        Next
        props = mCalc(n_bks, 0).getDocumentProperties()    'Define the document properties object and
        mCalc(n_bks, 1) = props.title                       'use it to store the tite of tgis workbook.
        
        mnu.Enabled = True  'Enable the 'Routines' menu.
        
        loaded = True
    Else
        close_down_multi loaded
    End If
    
End Sub

'Routine to run an HTML file in the default browser.
'Procedure name:    run_help(cd)
'Parameter:         cd;  the Help section selection code.

Sub run_help(cd)

    Dim o_txt As String
    
    o_txt = vb_path + "Help\opener" + CStr(cd) + ".htm"    'Define the name of the required 'opener' file.

    On Error GoTo errer
    
    ShellExecute 0, "Open", o_txt, "", "", vbNormalFocus    'Open the 'opener' and hence 'Help.htm' with the required active section.
Exit Sub

errer:
    MsgBox "Error #" & str(Err.Number) & " was generated by " _
            & vbCrLf & Err.Source & vbCrLf & Err.Description, _
            0, 16, "BROWSER ERROR"
                              
    Err.Clear       'Clear the error object.

End Sub

'Routine to read the 'Date last Modified' for the program file.
'Function name: date_modified()

Function date_modified()

    Dim d_m, filespec As String
    Dim FSO, fle As Object
    
    d_m = ", "  'Set the initial part of return string and
    filespec = vb_path + "LOT.exe"    'store the full-path, file name.
  
    Set FSO = CreateObject("Scripting.FileSystemObject")    'Define the File System Object and
    Set fle = FSO.GetFile(filespec)     'get the file object.
    
    d_m = d_m + Format(fle.DateLastModified, "dd/mm/yyyy")  'Format the date Last Modified.

    Set FSO = Nothing   'Release the object handles.
    Set fle = Nothing
    
    date_modified = d_m

End Function

'Routine to close a single file when multiple files may be open.
'Procedure name:    close_file()

Sub close_single_file()

    Dim j, k, p1, p2, pos As Integer
    Dim fn, fid As String
    Dim arg()
    
    On Error Resume Next    'This is necessary as, without it, the 'Close' command generates a fatal error.
    
    fn = select_file_save    'Uses ShowSave but just to get file name.
    
    p1 = InStrRev(fn, "\")              'Find the name
    p2 = InStrRev(fn, ".")              'delimiters and hence
    fid = Mid(fn, p1 + 1, p2 - p1 - 1)  'the file ID.
 
    pos = find_file(fid)
        If pos > 0 Then 'the file is in the Loaded list, so
            fn = ConvertToUrl(fn)                       'Convert the file path to LO form,
            n_shts = mCalc(pos, 0).sheets.Count         'count the sheets and
            Call mCalc(pos, 0).storeToURL(fn, arg())    'save the file.
            mCalc(pos, 0).Close True        'Close the workbook and
            Set mCalc(pos, 0) = Nothing     'release its object.
            For k = 0 To n_shts - 1             'Release the sheet objects
                Set mSheets(j, k) = Nothing     'for this workbook.
            Next
            For j = pos To n_bks                'Overwrite the deleted file data.
                For k = 0 To 1
                    mCalc(j, k) = mCalc(j + 1, k)
                Next
            Next
            n_bks = n_bks - 1   'Decrement the open workbook count.
        Else
            MsgBox "File " + fid + " hasn't been opened."
        End If

End Sub

'Routine to select and get the name of a  data file.
'Function name: select_file()

 Function select_file_save()
 
    Dim flgg As Long
    Dim fltr, ttl, f_n As String

    fltr = "LO  files(*.ODS)" & Chr$(0) & "*.ODS"
    flgg = cdlOFNNoChangeDir Or cdlOFNPathMustExist Or cdlOFNHideReadOnly 'Set up the flags
    ttl = "LibreOffice with VB6: SELECT AN 'ODS' FILE to SAVE and CLOSE"
 
    f_n = cdc.ShowSave(LOT_form.hwnd, fltr, "ods", flgg, ttl, vb_path)

    select_file_save = f_n
    
End Function

'Routine to find a file ID in the loaded files list.
'Function name: find_file(i_d)
'Parameter:     o_d;     the ID.

Function find_file(i_d)

    Dim j, f_f As Integer
    
    f_f = 0
    
    If n_bks > 0 Then 'there are some open files, so
        For j = 1 To n_bks
            If mCalc(j, 1) = i_d Then 'this is it, so
                f_f = j 'Store the value and
                j = n_bks
            End If
        Next
    End If
    
    find_file = f_f 'Return the value.
    
End Function

'Routine to close the only open file.
'Procedure name:    close_file()

Sub close_file(flg)

    Dim j As Integer
    
    If flg Then
        On Error Resume Next    'This is necessary as, without it, the 'Close' command generates a fatal error.
        
        n_shts = loCalc.sheets.Count
        loCalc.Close True       'Close the workbook and
        Set loCalc = Nothing    'release its object.
        For j = 0 To n_shts - 1         'Release the sheet objects
            Set loSheets(j) = Nothing   'for this workbook.
        Next
    Else
        MsgBox "There is no open file."
    End If

End Sub

'Routine to close down the system when a single file is open.
'Procedure name:    close_down(flg)
'Parameter:         flg;    the 'loaded' flag, if False then no workbook loaded.

Sub close_down(flg)
    
    Dim fc As Integer
    
    close_file flg

    Set cdc = Nothing       'Release the CDC class handle.
    Set rnge = Nothing      'Release the handles
    Set act_sht = Nothing   'in increasing order of complexity
    Set loDesk = Nothing    'i.e.  Range of cells, Sheet, Workbook,
    Set loSM = Nothing
        
    'UNLOAD ALL FORMS TO CLOSE THE APPLICATION.
    fc = -1
    Do Until fc = 0 'It has to be done this way because, as forms are unloaded, the remaining indices change.
        fc = Forms.Count - 1    'Unload all Loaded forms.
        Unload Forms(fc)
    Loop
    
End Sub

'Routine to close down the system when multiple files may be open.
'Procedure name:    close_down_multi(flg)
'Parameter:         flg;    the setup flag, if False then no workbook loaded.

Sub close_down_multi(flg)
    
    Dim j, k, fc As Integer
    
    If flg Then
        On Error Resume Next    'This is necessary as, without it, the 'Close' command generates a fatal error.
        
        For j = 1 To n_bks
            n_shts = mCalc(j, 0).sheets.Count
            mCalc(j, 0).Close True       'Close the workbook and
            Set mCalc(j, 0) = Nothing    'release its object.
            For k = 0 To n_shts - 1             'Release the sheet objects
                Set mSheets(j, k) = Nothing    'for this workbook.
            Next
        Next
    End If

    Set cdc = Nothing   'Release the CDC class handle.
    Set rnge = Nothing      'Release the handles
    Set act_sht = Nothing   'in increasing order of complexity
    Set loDesk = Nothing    'i.e.  Range of cells, Sheet, Workbook,
    Set loSM = Nothing
        
    'UNLOAD ALL FORMS TO CLOSE THE APPLICATION.
    fc = -1
    Do Until fc = 0 'It has to be done this way because, as forms are unloaded, the remaining indices change.
        fc = Forms.Count - 1    'Unload all Loaded forms.
        Unload Forms(fc)
    Loop
    
End Sub

