/*Script to process the contents of a Help DATA file to display selected pages and search for key words.
This version for LO VB6
Created:	7/1/14
Updated:	8/1/14, 12/1/14, 13/1/14, 14/1/14, 17/1/14, 18/1/14, 19/1/14, 7/4/20, 15/4/20, 18/4/20, 25/4/20
 Philip Bolt, 2014. phb@redhall.org.uk. www.redhall.org.uk

Update	12/1/14, 	allow 'key' case to be changed and to select 'key' case insensitive. This required a change in the operation of 'un_lite' 
which now works by storing and replacing the whole section. Check that a keyword has been entered before doing anything.

Update	13/1/14, 	Recognise any form of the key word/phrase and replace with the same form only highlit.

Update	14/1/14, 	Add checks on 'table' tag as tables within a para. are invisible as you can't have one block element inside another, (<p>).

Update	17/1/14,	Change strategy to search for start and end of tags, (< & >), thus removing the need for ANY exclusions.

Update	17/1/14,	Change strategy to only replace pieces of text which have been highlit.

Update	2/4/20		Changes to be used with single file Help package.

Update	18/4/20		Return to handling all selections via JS as CSS + JS mode incompatible. This also allows return to two stage selection of data.
					History now stored for each set of operations.
*/
//Display & Back variables.
var str="s0";			//Set up pointing to the beginning of the file.
var prev="s0";
var prev_hash="#top";	//Set up pointing to the beginning of the file, v0
var str_hash="#top";
var h_pt=[0,0,0,0];		//Initialise the HISTORY pointers and 
var pt =[0,0,0,0];		//the general section pointer, (4 zeros needed as subscript 0 isn't used).

var hist = function(m_sec, s_sec) 	//Define the 'History' elements array.
	{
    this.main_sec = m_sec;
    this.sub_sec = s_sec;
	};
 	
var histry=new Array(3);	//Define the 'Histry' array.
	for (var j=0; j<4; j++)
		{
		var r_a_d= new Array(1);
		for (var k=0; k<r_a_d.length; k++)
			{
			r_a_d[k]=hist;	//Initialise with 'hist' arrays.
			}
		histry[j]=r_a_d;
		}
 	
//Tab menus selection variables.
var p_tab=1;	//Set for the initial selection of CONTENTS.

//Checker variables.
var lft;
var s="s";
var t="t";
var sect;
var ttl;
var title;
var key="";
var content;
var content_txt="";
var cnt=0;

//hilite variables
var str_s="s0";		//Set up pointing to the dummy zero section.
var prev_s="s0";
var tg_st="<";		//String for Tag start and
var tg_nd=">";		//end characters.
var occ="";
var hi_pre = "<span style=\"background:#ffff80;\">";	//Highlight pre code for a yellow background
var hi_post = "</span>";	//Highlight post code.

//Get the section code off the 'opener' file.
var dta = "";
var searchString = document.location.search;
searchString = unescape(searchString.substring(1));
if (searchString!="")
	{
	var dta = searchString.split("&");			// strip off the leading '?'
	}

/*Create the section codes array, ('0' is to ensure that the first section is defined by array subscript 1, etc.)
The values below must match the numbers of the various sections of the data area.*/
var itms=[0,1,2,3,4,5,6,7,8,9,10,11,12,13,14]
var nd=itms.length-1;

//Create an array for the ListBox items large enough to allow ALL sections to be listed.
var lb=new Array(nd+1);
	for (var j=0; j<lb.length; j++)
		{
		var r_a_d= new Array(2);
		for (var k=0; k<r_a_d.length; k++)
			{
			r_a_d[k]="";	//Initialise with nulls.
			}
		lb[j]=r_a_d;
		}

//Routine  run on starting up.
//Function name:	start_up()

function start_up()
	{
	//Clear everything for a start.
	for (var i = 1; i < 4; i++)
		{
		var t_cd="tt"+i.toString();		//Create the menu code and
		var l_cd="lhs"+i.toString();	//the LHS section code.	
		document.getElementById(t_cd).className="";				//Clear the MENU ITEM class name and
		document.getElementById(l_cd).style.display = "none";	//hide the LHS section.
		}
	//Check the selection.
	if (dta=="")	//If there's no value for the selection,
		{
		dta=1;		//set it to CONTENTS.
		}
	var t_cd="tt"+dta.toString();	//Create the selected menu code and
	var l_cd="lhs"+dta.toString();	//the LHS section code.	
	document.getElementById(t_cd).className="selected";				//Set the MENU ITEM class name and
	document.getElementById(l_cd).style.display = "inline-block";	//display the LHS section.	
	p_tab=dta;
	}

/* Tab menu control function.
Parameters:		tb;		the section ID CODE for the selected Tab menu item.*/

function selekt(tb)
	{
	//Define the section variables.
	var t_cd="tt"+tb.toString();	//Create the menu code and
	var l_cd="lhs"+tb.toString();	//the LHS section code.
	
	var t_p="tt"+p_tab.toString();	//Create the PREVIOUS menu code and
	var l_p="lhs"+p_tab.toString();	//the PREVIOUS LHS section code.
	
	//Clear the previous selection.
	if (p_tab==3)	//Remove any existing highlighting,.		
		{
		clear_hilite();	//Remove any existing highlit text.
		document.getElementById(str).style.display = "none";			//Clear the display of the current section and
		document.getElementById('s0').style.display = "inline-block";	//set it to the blank ,s0.
		}
			
	document.getElementById(t_p).className="";				//Clear the MENU ITEM class name,
	document.getElementById(l_p).style.display = "none";	//hide the LHS section and
	p_tab=tb;												//store the current menu selection.
	
	document.getElementById(t_cd).className="selected";				//Set the MENU ITEM class to selected and
	document.getElementById(l_cd).style.display = "inline-block";	//display the LHS section.

	if(tb==3)															//If SEARCH is selected,
		{
		document.getElementById('ex').style.visibility = "hidden";		//hide the Expand and 
		document.getElementById('col').style.visibility = "hidden";		//and Collapse <div>s.
		}
	else																//Otherwise,
		{
		document.getElementById('ex').style.visibility = "visible";		//display the <div>s. 
		document.getElementById('col').style.visibility = "visible";	
		} 
		
	//Hide the 'Back' and 'Forward' buttons, BUT then check for history.
	document.getElementById("bk").style.visibility = "hidden";	//Hide the 'Back' and
	document.getElementById("fr").style.visibility = "hidden";	//'Forward' button.
 	
	//Check for any history for this option.
	if(pt[tb]>0)	//then there is some stored history, so
		{
		document.getElementById("bk").style.visibility = "visible";	//display the 'Back' button and
		h_pt[tb]=pt[tb];		//set the history pointer to the current last entry.
		}
	}
	 
/* Main display function for CONTENTS and INDEX options.
Parameters:		dv;		the section code for display,
				hsh;	ID for a particular part of the section*/
				
function display(dv, hsh)
	{
	clear_hilite()	//Clear any highlighting in case this was a link from a highlit section.
	
	prev=str;												//Store the 'Previous' section code and
	document.getElementById(str).style.display = "none";	//hide the current display.
	str=dv;													//Store the requested area flag and
	document.getElementById(dv).style.display = "block";	//display the section.
 
	if(hsh!==undefined && hsh!=="")	//If there is a location ID
		{							
		var hs = "#"+hsh;			//store the hash value.	
		}
	else							//Otherwise,
		{
		var hs = "#"+dv;			//set it to jump to the top of the section.
		}
	document.location.hash = hs;	//Jump.
 	
	prev_hash=str_hash;			//Store the 'previous' hash value and
	str_hash=hs;				//the current value.
	
	histry[p_tab].push(new hist(dv, hsh));	//Add the section data to the History array,
	h_pt[p_tab]=histry[p_tab].length-1;		//store the value of the HISTORY pointer and
	pt[p_tab]=h_pt[p_tab];					//the general pointer value.
		 										
	if(h_pt[p_tab]>1)	//If there was a 'Previous' section  
		{
		document.getElementById("bk").style.visibility = "visible";	//display the 'Back' button.
		}
	}

/*Function run when the 'BACK' or 'FORWARD' buttons are clicked.
Parameter:	cd,	The step value, -1 for Back, +1 for Forward.*/

function b_f(cd)
	{
	if(p_tab==3)	//this is a 'Search' request.
		{
		h_pt[p_tab]=h_pt[p_tab]+cd						//Modify the history pointer.
		var h_sec=histry[p_tab][h_pt[p_tab]].main_sec;	//Store the  section code and 
		var key=histry[p_tab][h_pt[p_tab]].sub_sec;		//the KEY value.
		str_s=h_sec										//the corresponding section code.
													
		//Select the section required.
		check_txt=document.getElementById(str_s).innerHTML.trim();	//Store its contents for highlighting and
		content_txt=check_txt;										//the unchanged text for checking and later replacement, ('low_lite()').
 
		var p_st=0;						//Initialise the text pointers.
		var p_nd=0;
		var tst_txt=""					//Initialise the testing string and
		var ret_txt=""					//the return string.
		var c_len=content_txt.length;	//Store the length of the string.	
		var nt_done=true;				//Initialise the loop flag.
 		
		//Loop through the TEXT
		while (nt_done)	
			{
			p_nd=content_txt.indexOf(tg_st, p_st);  //Find the next '<'.		
			if (p_nd!=p_st)
				{
				if (p_nd<0)	//This means no '<' before the end of the file so,
					{
					p_nd=c_len; 	//set the pointer to the end of the section and
					nt_done=false;	//flag to exit the loop.
					}
				tst_txt=content_txt.slice(p_st,p_nd);	//Cut out a section of text.		
				//Create an array of occurrences of any form of the key in this piece of text as a complete word/phrase. There may be duplicates.
				occ=tst_txt.match(new RegExp("\\b"+key+"\\b", 'gi'));	
				if (occ!==null && occ!=="")			//If there were some occurrences,
					{
					for(var k=0;k<occ.length;k++)	//loop through the occurrence array items.
						{	
						if (not_done(k))	//If this one hasn't already been done,
							{
							//replace this form of the key by the same form with highlighting.
							ret_txt=tst_txt.replace(new RegExp("\\b"+occ[k]+"\\b", 'g'),hi_pre+occ[k]+hi_post);
							}
						}
					check_txt=check_txt.replace(tst_txt,ret_txt);	//Replace the highlit text in the section text.
					}	
				
				p_st=p_nd; 			//Set the next Start value.
				if (p_st==c_len)	//This is the end of the text, so
					{
					nt_done=false;	//flag to exit the loop.
					}
				}
			p_nd=content_txt.indexOf(tg_nd, p_st)+1;  //Find the next '>' and hence the position of the Tag text.
			if (p_nd==0)	//There wasn't one before the end of the text, (THERE SHOULD BE!)
				{
				p_nd=c_len-1;	//Set the value for the end of the string and
				nt_done=false;	//flag to exit the loop.
				}
 
			//Don't do anything here, as it's Tag text, other than
			p_st=p_nd; //reset the Start pointer.
			}	//Loop		
	 		
			document.getElementById(str_s).innerHTML=check_txt;			//Return the highlit text to the display.		
			document.getElementById(prev_s).style.display = "none";		//Hide any previous display,
			
			document.getElementById(str_s).style.display = "block";		//display the selected section.
			prev_s=str_s;	//Store the code for later clearing.
		}
	else //it must be a 'Contents' or 'Index' item.	
		{
		prev=str;
		document.getElementById(str).style.display = "none";	//Hide the current display.
	
		h_pt[p_tab]=h_pt[p_tab]+cd						//Modify the history pointer.
		var h_sec=histry[p_tab][h_pt[p_tab]].main_sec;	//Store the previous section code and 
		var h_hsh=histry[p_tab][h_pt[p_tab]].sub_sec;	//hash value.
		str=h_sec
 
		if (h_pt[p_tab]==1)	 											//We're at the start, so
			{
			document.getElementById("bk").style.visibility = "hidden";	//hide the 'Back' button.	
			}
		
		document.getElementById(h_sec).style.display = "block";			//Display the section.
		
		if(h_hsh!==undefined && h_hsh!=="")	//If there is a location ID
			{							
			var hs = "#"+h_hsh;				//store the hash value.	
			}
		else								//Otherwise,
			{
			var hs = "#"+h_sec;				//set it to jump to the top of the section.
			}
		document.location.hash = hs;		//Jump.
		
		prev_hash=str_hash;			//Store the 'previous' hash value and
		str_hash=hs;				//the current value.
		}
		
	if(h_pt[p_tab]<pt[p_tab])	//We're not back to the most recent item, so
		{
		document.getElementById("fr").style.visibility = "visible";	//show the 'Forward' button.
		}
	else															//Otherwise,
		{
		document.getElementById("fr").style.visibility = "hidden";	//hide the 'Forward' button.
		}
	}
	
//Function run when the Content or Index file is unloaded.

function close()
	{
	document.getElementById(str).style.display = "none";	//hide the current display.
	}

//Function to check for the presence of a KEY word or phrase in the various sections.

function checker()
	{
	clear_hilite();	//Remove any existing highlit text./document.getElementById('s0').style.display = "inline-block";

	key=document.getElementById("key").value;	//Get any text entered on the 'Search' form.
	if (key!="")	//Check that a key word was entered.
		{
		cnt=0;		//Zero the count of applicable sections.
		var exp=new RegExp("\\b"+key+"\\b", 'i');
 
		//Loop through the SECTIONS.
		for (var i = 1; i < nd+1; i++)
			{
			var cd=itms[i].toString();	//Create the section number code,
			sect=s+cd;					//the section and
			ttl=t+cd;					//title codes.
 
			if (document.getElementById(ttl)!=null)	//Check that this element exists.
				{
				title=document.getElementById(ttl).textContent;				//Store the Title of this section and
				content=document.getElementById(sect).textContent.trim();	//its contents to be checked.
  
				var c_len=content.length;	//Store the length of the content string.	
				var nt_done=true;			//Initialise the loop flag.
				
				if (c_len!=0 && content.match(exp)!=null)	//There is some text and there is a match for the key expression.
					{
					cnt=cnt+1;			//increment the number of hits,
					lb[cnt][0]=title;	//store the section Title and 
					lb[cnt][1]=sect;	//its Code in the array.				
					}
				}
			}	//SECTION loop.
  
		if (cnt!=0)	//Some occurrences of the key have been found, so
			{
			//Populate the ListBox with the Titles from the array.
			var selkt = document.getElementById("sel_list");	//Define the Box variable and
			selkt.options.length = 0;							//clear any previous items.
			//Loop through each identified section.
			for (var i = 0; i < cnt+1; i++)
				{ 
				selkt.options[i] = new Option(lb[i][0],lb[i][0]);	//Add the Title as both Value and Text.
				}
			}
		else
			{
			//Display message "No instances of 'key' were found".
			document.getElementById("key").value = "No instances of '"+key+"' were found.";
			}
		}
	}

//Function to highlight and display a selected section.

function hilite()
	{
	if(cnt!=0)	//Only process if some occurrences were found.
		{
		low_lite(prev_s);	//Remove any existing highlighting by restoring the previous section text.
		
		var idx=document.getElementById("sel_list").selectedIndex;	//Store the selected index and
		str_s=lb[idx][1];											//the corresponding section code.
	
		//Select the section required.
		check_txt=document.getElementById(str_s).innerHTML.trim();	//Store its contents for highlighting and
		content_txt=check_txt;										//the unchanged text for checking and later replacement, ('low_lite()').
 
		var p_st=0;						//Initialise the text pointers.
		var p_nd=0;
		var tst_txt=""					//Initialise the testing string and
		var ret_txt=""					//the return string.
		var c_len=content_txt.length;	//Store the length of the string.	
		var nt_done=true;				//Initialise the loop flag.
 		
		//Loop through the TEXT
		while (nt_done)	
			{
			p_nd=content_txt.indexOf(tg_st, p_st);  //Find the next '<'.		
			if (p_nd!=p_st)
				{
				if (p_nd<0)	//This means no '<' before the end of the file so,
					{
					p_nd=c_len; 	//set the pointer to the end of the section and
					nt_done=false;	//flag to exit the loop.
					}
				tst_txt=content_txt.slice(p_st,p_nd);	//Cut out a section of text.		
				//Create an array of occurrences of any form of the key in this piece of text as a complete word/phrase. There may be duplicates.
				occ=tst_txt.match(new RegExp("\\b"+key+"\\b", 'gi'));	
				if (occ!==null && occ!=="")			//If there were some occurrences,
					{
					for(var k=0;k<occ.length;k++)	//loop through the occurrence array items.
						{	
						if (not_done(k))	//If this one hasn't already been done,
							{
							//replace this form of the key by the same form with highlighting.
							ret_txt=tst_txt.replace(new RegExp("\\b"+occ[k]+"\\b", 'g'),hi_pre+occ[k]+hi_post);
							}
						}
					check_txt=check_txt.replace(tst_txt,ret_txt);	//Replace the highlit text in the section text.
					}	
				
				p_st=p_nd; 			//Set the next Start value.
				if (p_st==c_len)	//This is the end of the text, so
					{
					nt_done=false;	//flag to exit the loop.
					}
				}
			p_nd=content_txt.indexOf(tg_nd, p_st)+1;  //Find the next '>' and hence the position of the Tag text.
			if (p_nd==0)	//There wasn't one before the end of the text, (THERE SHOULD BE!)
				{
				p_nd=c_len-1;	//Set the value for the end of the string and
				nt_done=false;	//flag to exit the loop.
				}
 
			//Don't do anything here, as it's Tag text, other than
			p_st=p_nd; //reset the Start pointer.
			}	//Loop		
	 		
			document.getElementById(str_s).innerHTML=check_txt;			//Return the highlit text to the display.		
			document.getElementById(prev_s).style.display = "none";		//Hide any previous display,
			
			document.getElementById(str_s).style.display = "block";		//display the selected section.
			prev_s=str_s;	//Store the code for later clearing.
			
			histry[p_tab].push(new hist(str_s, key));	//Add the section data and the KEY text to the History array,
			h_pt[p_tab]=histry[p_tab].length-1;			//store the value of the HISTORY pointer and
			pt[p_tab]=h_pt[p_tab];						//the general pointer value.
			
			if (prev_s!="s0")													//If there was a 'Previous' section
				{
				document.getElementById("bk").style.visibility = "visible";	//display the 'Back' button.
				}
		}
	}
	
//Routine to check if a particular form of the key has been replaced.
//Parameter:	kk;	the current array subscript.

function not_done(kk)
	{
	var n_d=true;			//Set a default return value.
	for(var l=0;l<kk;l++)	//Loop through the occurrence array from the start to the current position less 1.
		{
		if(occ[l]==occ[kk])	//If the same value is found, then it's already been dealt with, so
			{
			n_d=false;		//set a False return value.
			}
		}
	return n_d;
	}

//Function remove the highlighting from a section.

function low_lite(sc)
	{
	content=document.getElementById(sc);	//Store the selected section contents and
	content.innerHTML=content_txt;			//replace the original text.
	}
	
//Function to clear any remaining highlights when the Search option is closed.

function clear_hilite()
	{
	if (prev_s!="s0")	//Check to see if any highlighting has been carried out.
		{
		low_lite(prev_s);	//If so, clear the highlights and
		document.getElementById(prev_s).style.display = "none";		//hide the display,
		}
	}

