VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDC_class"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'CLASS MODULE TO REPLACE THE CommonDialog CONTROL.

'There is nothing here that is specific to any
'particular project except that:-
'The routines require a Public Boolean, 'canceled', in the main program.
'In fact, this can be removed and a failed process detected by the value returned by functions.
'It's kept in here because I used it in applications which used the CD control.

' Philip Bolt, 2006, 2007

'The code is based on that from http://www.mentalis.org/apilist/PrintDialog.shtml, 'Common Dialogs'
'example with additional code and data from http://www.ex-designz.net/apicat.asp and Paul Mather's
'program at http://www.Planet-Source-Code.com/vb/scripts/ShowCode.asp?txtCodeId=3592&lngWId=1

'Last updated: 16/11/2007

'Code added from Microsoft article 266767, http://support.microsoft.com/kb/266767/EN-US/,
'to allow the selected printer to be set as the default as Set Printer = [Printer object]
'won't always work.
'This section also has to read the OS type as Win95, etc. requires different code from
'WinNT types.

'There is a Boolean flag, 'make_default', accessed via the 'default_flag' property,
'which controls whether changes made to paper size, bin etc. are  stored after
'selection as global preferences, (make_default = TRUE), or whether they only apply to
'the application calling the routine, (make_default = FALSE). The flag defaults to TRUE
'when a CCD_class object is created.

Option Explicit

'CD CONSTANTS.
'To be compatible with previous applications which used the CD control, the constants
'have been defined using the VB 6.0 nomenclature rather than the standard form as used
'with C++, etc.
'e.g. cdlOFNEnableHook rather than OFN_ENABLEHOOK.
'This is done even when there are no VB values, as for the PAGESETUP constants.

'Those constants which are described in the 'Visual Studio Help'/'CommonDialog Control
'Constants' are NOT documented. In fact, ALL of the constants are documented in their
'standard forms in the C++ versions of the API structures. e.g. 'Help'/'PRINTDLG'.
    
'OPEN/SAVE FILES
Public Enum cdlOFN
    cdlOFNAllowMultiselect = &H200
    cdlOFNCreatePrompt = &H2000
    cdlOFNExplorer = &H80000
    cdlOFNExtensionDifferent = &H400
    cdlOFNFileMustExist = &H1000
    cdlOFNHelpButton = &H10
    cdlOFNHideReadOnly = &H4
    cdlOFNLongNames = &H200000
    cdlOFNNoChangeDir = &H8
    cdlOFNNoDereferenceLinks = &H100000
    cdlOFNNoLongNames = &H40000
    cdlOFNNoReadOnlyReturn = &H8000
    cdlOFNNoValidate = &H100
    cdlOFNOverwritePrompt = &H2
    cdlOFNPathMustExist = &H800
    cdlOFNReadOnly = &H1
    cdlOFNShareAware = &H4000
    cdlOFNEnableHook = &H20             'Enables the hook function specified in the lpfnHook
                                        'member.
    cdlOFNEnableTemplateHandle = &H80   'Indicates that the hInstance member identifies a data
                                        'block that contains a preloaded dialog box template.
                                        'The system ignores the lpTemplateName if this flag is
                                        'specified.'
                                        'If the cdlOFNExplorer flag is set, the system uses the
                                        'specified template to create a dialog box that is a
                                        'child of the default Explorer-style dialog box. If the
                                        'cdlOFNExplorer flag is not set, the system uses the
                                        'template to create an old-style dialog box that
                                        'replaces the default dialog box.
    cdlOFNEnableTemplate = &H40         'Indicates that the lpTemplateName member points to the
                                        'name of a dialog template resource in the module
                                        'identified by the hInstance member.
                                        'If the cdlOFNExplorer flag is set, the system uses the
                                        'specified template to create a dialog box that is a
                                        'child of the default Explorer-style dialog box.
                                        'If the cdlOFNExplorer flag is not set, the system uses
                                        'the template to create an old-style dialog box that
                                        'replaces the default dialog box.
    cdlOFNNoTestFileCreate = &H10000    'Specifies that the file is not created before the
                                        'dialog box is closed. This flag should be specified if
                                        'the application saves the file on a create-nonmodify
                                        'network share. When an application specifies this flag,
                                        'the library does not check for write protection, a full
                                        'disk, an open drive door, or network protection.
                                        'Applications using this flag must perform file operations
                                        'carefully, because a file cannot be reopened once it is
                                        'closed.
    cdlOFNNoNetworkButton = &H20000     'Hides and disables the Network button.
    cdlOFNEnableSizing = &H800000       'Windows NT 5.0, Windows 98: Enables the Explorer-style
                                        'dialog box to be resized using either the mouse or the
                                        'keyboard. By default, the Explorer-style Open and Save
                                        'As dialog boxes allow the dialog box to be resized
                                        'regardless of whether this flag is set. This flag is
                                        'necessary only if you provide a hook procedure or
                                        'custom template. The old-style dialog box does not
                                        'permit resizing.
End Enum

'SELECT PRINTER
Public Enum cdlPD
    cdlPDAllPages = &H0
    cdlPDCollate = &H10
    cdlPDDisablePrintToFile = &H80000
    cdlPDHelpButton = &H800
    cdlPDHidePrintToFile = &H100000
    cdlPDNoPageNums = &H8
    cdlPDNoSelection = &H4
    cdlPDNoWarning = &H80
    cdlPDPageNums = &H2
    cdlPDPrintSetup = &H40
    cdlPDPrintToFile = &H20
    cdlPDReturnDC = &H100
    cdlPDReturnDefault = &H400
    cdlPDReturnIC = &H200
    cdlPDSelection = &H1
    cdlPDUseDevModeCopies = &H40000
    cdlPDEnablePrintHook = &H1000               'Enables the hook procedure specified in the
                                                'lpfnPrintHook member. This enables the hook
                                                'procedure for the Print dialog box.
    cdlPDEnableSetupHook = &H2000               'Enables the hook procedure specified in the
                                                'lpfnSetupHook member. This enables the hook
                                                'procedure for the Print Setup dialog box.
    cdlPDEnablePrintTemplate = &H4000           'Indicates that the hInstance and lpPrintTemplateName
                                                'members specify a replacement for the default
                                                'Print dialog box template.
    cdlPDEnableSetupTemplate = &H8000           'Indicates that the hInstance and lpSetupTemplateName
                                                'members specify a replacement for the default
                                                'Print Setup dialog box template.
    cdlPDEnablePrintTemplateHandle = &H10000    'Indicates that the hPrintTemplate member
                                                'identifies a data block that contains a preloaded
                                                'dialog box template.
                                                'This template replaces the default template for
                                                'the Print dialog box. The system ignores the
                                                'lpPrintTemplateName member if this flag is
                                                'specified.
    cdlPDEnableSetupTemplateHandle = &H20000    'Indicates that the hSetupTemplate member
                                                'identifies a data block that contains a preloaded
                                                'dialog box template. This template replaces the
                                                'default template for the Print Setup dialog box.
                                                'The system ignores the lpSetupTemplateName
                                                'member if this flag is specified.
    cdlPDUseDEVMODECopiesAndCollate = &H40000   'This flag indicates whether your application
                                                'supports multiple copies and collation.
                                                'Set this flag on input to indicate that your
                                                'application does not support multiple copies
                                                'and collation. In this case, the nCopies member
                                                'of the PRINTDLG structure always returns 1,
                                                'and cdlPDCollate is never set in the Flags
                                                'member.
    cdlPDNoNetworkButton = &H200000             'Hides and disables the Network button.
End Enum

'SELECT COLOR BOX
Public Enum cdlCC
    cdlCCRGBInit = &H1
    cdlCCFullOpen = &H2
    cdlCCPreventFullOpen = &H4
    cdlCCShowHelp = &H8
    cdlCCEnableHook = &H10              'Use the hook function specified by lpfnHook to process
                                        'the Choose Color box's messages.
    cdlCCEnableTemplate = &H20          'Use the dialog box template identified by hInstance
                                        'identified by hInstance, ignoring lpTemplateName.
    cdlCCEnableTemplateHandle = &H40    'Use the preloaded dialog box template identified by
                                        'hInstance, ignoring lpTemplateName.
    cdlCCSolidColor = &H80              'Only allow the user to select solid colors.
                                        'If the user attempts to select a non-solid color,
                                        'convert it to the closest solid color.
    cdlCCAnyColor = &H100               'Allow the user to select any colour.
End Enum

'SELECT FONTS
Public Enum cdlCF
    cdlCFANSIOnly = &H400
    cdlCFApply = &H200
    cdlCFBoth = &H3
    cdlCFEffects = &H100
    cdlCFFixedPitchOnly = &H4000
    cdlCFForceFontExist = &H10000
    cdlCFHelpButton = &H4               'A.k.a ShowHelp, FontShowHelp.
    cdlCFLimitSize = &H2000
    cdlCFNoFaceSel = &H80000
    cdlCFNoSimulations = &H1000
    cdlCFNoStyleSel = &H100000
    cdlCFNoVectorFonts = &H800
    cdlCFPrinterFonts = &H2
    cdlCFScalableOnly = &H20000
    cdlCFScreenFonts = &H1
    cdlCFTTOnly = &H40000
    cdlCFWYSIWYG = &H8000
    cdlCFEnableHook = &H8               'Use the hook function specified by lpfnHook to process
                                        'the Choose Font dialog's messages.
    cdlCFEnableTemplate = &H10          'Use the dialog box template specified by lpTemplateName.
    cdlCFEnableTemplateHandle = &H20    'Use the preloaded dialog box template specified by
                                        'hInstance.
    cdlCFInittoLogFontStruct = &H40     'Use the settings specified in lpLogFont to select a
                                        'default font in the dialog box.
    cdlCFUseStyle = &H80                'Use information in lpStyle to initialize the dialog box.
    cdlCFScriptsOnly = &H400            'Win NT only: Same as cdlCFANSIOnly.
    cdlCFNoOEMFonts = &H800             'Same as cdlCFNoVectorFonts.
    cdlCFSelectScript = &H400000        'Win 95/98 only: Only list fonts with the proper
                                        'character set.
    cdlCFNoSizeSel = &H200000           'When using aLOGFONT structure to initialize the dialog
                                        'box controls, use this flag to selectively prevent the
                                        'dialog box from displaying an initial selection for the
                                        'font size combo box.
                                        'This is useful when there is no single font size that
                                        'applies to the text selection.
    cdlCFNoScriptSel = &H800000         'Do not select a default script setting for the user.
    cdlCFNoVertFonts = &H1000000        'Win 95/98 only: Do not list vertically-oriented fonts.
    cdlCFNFontNotSupported = &H238      'cdlCFApply or cdlCFEnableHook or cdlCFEnableTemplate or
                                        'cdlCFEnableTemplateHandle
End Enum

'PAGE SETUP
Public Enum cdlPSD
    cdlPSDInWinIniIntlMeasure = &H0                 'Not implemented.
    cdlPSDDefaultMinMargins = &H0                   'Sets the minimum values that the user can
                                                    'specify for the page margins to be the
                                                    'minimum margins allowed by the printer.
                                                    'Zero is the default.
                                                    'This flag is ignored if the cdlPSDMargins
                                                    'and cdlPSDMinMargins flags are also
                                                    'specified.
    cdlPSDMinMargins = &H1                          'Causes the system to use the values
                                                    'specified in the rtMinMargin member as the
                                                    'minimum allowable widths for the left, top,
                                                    'right, and bottom margins.
                                                    'The system prevents the user from entering
                                                    'a width that is less than the specified
                                                    'minimum.
                                                    'If cdlPSDMinMargins is not specified, the
                                                    'system sets the minimum allowable widths to
                                                    'those allowed by the printer.
    cdlPSDMargins = &H2                             'Causes the system to use the values
                                                    'specified in the rtMargin member as the
                                                    'initial widths for the left,top, right, and
                                                    'bottom margins.
                                                    'If cdlPSDMargins is not set, the system sets
                                                    'the initial widths to one inch for all margins.
    cdlPSDInThousandthsofInches = &H4               'Indicates that thousandths of inches are the
                                                    'unit of measurement for margins and paper
                                                    'size.
                                                    'The values in the rtMargin, rtMinMargin,
                                                    'and ptPaperSize members are in thousandths
                                                    'of inches.
                                                    'You can set this flag on input to override
                                                    'the default unit of measurement for the
                                                    'user's locale.
                                                    'When the function returns, the dialog box
                                                    'sets this flag to indicate the units used.
    cdlPSDInHundredthsofMillimeters = &H8           'Indicates that hundredths of millimeters are
                                                    'the unit of measurement for margins and
                                                    'paper size.
                                                    'The values in the rtMargin, rtMinMargin, and
                                                    'ptPaperSize members are in hundredths of
                                                    'millimeters.
                                                    'You can set this flag on input to override
                                                    'the default unit of measurement for the
                                                    'user's locale.
                                                    'When the function returns, the dialog box
                                                    'sets this flag to indicate the units used.
    cdlPSDDisableMargins = &H10                     'Disables the margin controls, preventing the
                                                    'user from setting the margins.
    cdlPSDDisablePrinter = &H20                     'Disables the Printer button, preventing the
                                                    'user from invoking a dialog box that
                                                    'contains additional printer setup information.
    cdlPSDNoWarning = &H80                          'Prevents the system from displaying a
                                                    'warning message when there is no default
                                                    'printer.
    cdlPSDDisableOrientation = &H100                'Disables the orientation controls,
                                                    'preventing the user from setting the page
                                                    'orientation.
    cdlPSDDisablePaper = &H200                      'Disables the paper controls, preventing the
                                                    'user from setting page parameters such as
                                                    'the paper size and source.
    cdlPSDReturnDefault = &H400                     'PageSetupDlg does not display the dialog box.
                                                    'Instead, it sets the hDevNames and hDevMode
                                                    'members to handles to DEVMODE and DEVNAMES
                                                    'structures that are initialized for the
                                                    'system default printer.
                                                    'PageSetupDlg returns an error if either
                                                    'hDevNames or hDevMode is not NULL.
    cdlPSDShowHelp = &H800                          'Causes the dialog box to display the Help
                                                    'button.
                                                    'The hwndOwner member must specify the window
                                                    'to receive the HELPMSGSTRING registered
                                                    'messages that the dialog box sends when the
                                                    'user clicks the Help button.
    cdlPSDEnablePageSetupHook = &H2000              'Enables the hook procedure specified in the
                                                    'lpfnPageSetupHook member.
    cdlPSDEnablePageSetupTemplate = &H8000          'Indicates that the hInstance and
                                                    'lpPageSetupTemplateName members specify a
                                                    'dialog box template to use in place of the
                                                    'default template.
    cdlPSDEnablePageSetupTemplateHandle = &H20000   'Indicates that the hPageSetupTemplate
                                                    'member identifies a data block that contains
                                                    'a preloaded dialog box template.
                                                    'The system ignores the lpPageSetupTemplateName
                                                    'member if this flag is specified.
    cdlPSDEnablePagePaintHook = &H40000             'Enables the hook procedure specified in the
                                                    'lpfnPagePaintHook member.
    cdlPSDDisablePagePainting = &H80000             'Prevents the dialog box from drawing the
                                                    'contents of the sample page.
                                                    'If you enable a PagePaintHook hook
                                                    'procedure, you can still draw the contents
                                                    'of the sample page.
    cdlPSDNnNetworkButton = &H200000                'Hides and disables the Network button.
End Enum

'EXTENDED ERROR CODES
Private Enum CDERR
    CDERR_DIALOGFAILURE = &HFFFF    'The function could not open the dialog box.
    CDERR_FINDRESFAILURE = &H6      'The function failed to find the desired resource.
    CDERR_GENERALCODES = &H0        'The error involved a general common dialog box property.
    CDERR_INITIALIZATION = &H2      'The function failed during initialization (probably insufficient
                                    'memory).
    CDERR_LOADRESFAILURE = &H7      'The function failed to load the desired resource.
    CDERR_LOADSTRFAILURE = &H5      'The function failed to load the desired string.
    CDERR_LOCKRESFAILURE = &H8      'The function failed to lock the desired resource.
    CDERR_MEMALLOCFAILURE = &H9     'The function failed to allocate sufficient memory.
    CDERR_MEMLOCKFAILURE = &HA      'The function failed to lock the desired memory.
    CDERR_NOHINSTANCE = &H4         'The function was not provided with a valid instance handle (if one
                                    'was required).
    CDERR_NOHOOK = &HB              'The function was not provided with a valid hook function handle
                                    '(if one was required).
    CDERR_NOTEMPLATE = &H3          'The function was not provided with a valid template (if one was
                                    'required).
    CDERR_REGISTERMSGFAIL = &HC     'The function failed to successfully register a window message.
    CDERR_STRUCTSIZE = &H1          'The function was provided with an invalid structure size.
    CFERR_CHOOSEFONTCODES = &H2000  'The error involved the Choose Font common dialog box.
    CFERR_MAXLESSTHANMIN = &H2002   'The function was provided with a maximum font size value smaller
                                    'than the provided minimum font size.
    CFERR_NOFONTS = &H2001          'The function could not find any existing fonts.
    FNERR_BUFFERTOOSMALL = &H3003   'The function was provided with a filename buffer which was too
                                    'small.
    FNERR_FILENAMECODES = &H3000    'The error involved the Open File or Save File common dialog box.
    FNERR_INVALIDFILENAME = &H3002  'The function was provided with or received an invalid filename.
    FNERR_SUBCLASSFAILURE = &H3001  'The function had insufficient memory to subclass the list box.
    FRERR_BUFFERLENGTHZERO = &H4001 'The function was provided with an invalid buffer.
    FRERR_FINDREPLACECODES = &H4000 'The error involved the Find or Replace common dialog box.
    PDERR_CREATEICFAILURE = &H100A  'The function failed to create an information context.
    PDERR_DEFAULTDIFFERENT = &H100C 'The function was told that the information provided described the
                                    'default printer, but the default printer's actual settings were
                                    'different.
    PDERR_DNDMMISMATCH = &H1009     'The data in the two data structures describe different printers
                                    '(i.e., they hold conflicting information).
    PDERR_GETDEVMODEFAIL = &H1005   'The printer driver failed to initialize the DEVMODE structure.
    PDERR_INITFAILURE = &H1006      'The function failed during initialization.
    PDERR_LOADDRVFAILURE = &H1004   'The function failed to load the desired device driver.
    PDERR_NODEFAULTPRN = &H1008     'The function could not find a default printer.
    PDERR_NODEVICES = &H1007        'The function could not find any printers.
    PDERR_PARSEFAILURE = &H1002     'The function failed to parse the printer-related strings in
                                    'WIN.INI.
    PDERR_PRINTERCODES = &H1000     'The error involved the Print common dialog box.
    PDERR_PRINTERNOTFOUND = &H100B  'The function could not find information in WIN.INI about the
                                    'requested printer.
    PDERR_RETDEFFAILURE = &H1003    'The handles to the data structures provided were nonzero even
                                    'though the function was asked to return information about the
                                    'default printer.
    PDERR_SETUPFAILURE = &H1001     'The function failed to load the desired resources.
End Enum

'The VB Printer constants, (Help/Printer Object Constants), are all recognised but these apply
'to the Printer OBJECT, not to the PRINTDLG or PAGESETUPDLG structures.

Private Const CCHDEVICENAME = 32    'String buffer sizes.
Private Const CCHFORMNAME = 32
Private Const GMEM_MOVEABLE = &H2   'Memory manipulation flags.
Private Const GMEM_ZEROINIT = &H40

'The API data structures documentation can be found in the Help file.
'This is given for C++ code but the names and function are the same as below.
'e.g. 'Visual Basic Help'/'OPENFILENAME', 'PAGESETUPDLG', 'CHOOSECOLOR', etc.

'==============================================================================================
'FILE OPERATIONS, OPEN/SAVE.

Private Type OPENFILENAME
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    lpstrFilter As String
    lpstrCustomFilter As String
    nMaxCustFilter As Long
    nFilterIndex As Long
    lpstrFile As String
    nMaxFile As Long
    lpstrFileTitle As String
    nMaxFileTitle As Long
    lpstrInitialDir As String
    lpstrTitle As String
    flags As Long
    nFileOffset As Integer
    nFileExtension As Integer
    lpstrDefExt As String
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type

Private Type SelectedFile       'Custom Type to deal with multiple files.
    nFilesSelected As Integer   'Number of files selected.
    sFiles() As String          'File storage array.
    sLastDirectory As String    'Last directory accessed.
    bCanceled As Boolean        'CANCELed flag.
End Type

'==============================================================================================
'PRINTER SELECTION

Private Type PRINTDLG_TYPE
    lStructSize As Long
    hwndOwner As Long
    hDevMode As Long
    hDevNames As Long
    hDC As Long
    flags As Long
    nFromPage As Integer
    nToPage As Integer
    nMinPage As Integer
    nMaxPage As Integer
    nCopies As Integer
    hInstance As Long
    lCustData As Long
    lpfnPrintHook As Long
    lpfnSetupHook As Long
    lpPrintTemplateName As String
    lpSetupTemplateName As String
    hPrintTemplate As Long
    hSetupTemplate As Long
End Type

Private Type DEVNAMES_TYPE
    wDriverOffset As Integer
    wDeviceOffset As Integer
    wOutputOffset As Integer
    wDefault As Integer
    extra As String * 100
End Type

Private Type DEVMODE_TYPE
    dmDeviceName As String * CCHDEVICENAME  'See 'Help'/'DEVMODE'
    dmSpecVersion As Integer                        ''
    dmDriverVersion As Integer                      ''
    dmSize As Integer                               ''
    dmDriverExtra As Integer                        ''
    DMFIELDS As Long                        'See below.
    dmOrientation As Integer                    ''
    dmPaperSize As Integer                      ''
    dmPaperLength As Integer                'See 'Help'/'DEVMODE'
    dmPaperWidth As Integer                         ''
    dmScale As Integer                              ''
    dmCopies As Integer                             ''
    dmDefaultSource As Integer              'See below.
    dmPrintQuality As Integer                   ''
    dmColor As Integer                          ''
    dmDuplex As Integer                         ''
    dmYResolution As Integer                'See 'Help'/'DEVMODE'
    dmTTOption As Integer                   'See below.
    DMCOLLATE As Integer                        ''
    dmFormName As String * CCHFORMNAME      'See 'Help'/'DEVMODE'
    dmUnusedPadding As Integer              'Reserved. DO NOT USE.
    dmBitsPerPel As Integer                 'See 'Help'/'DEVMODE'
    dmPelsWidth As Long                             ''
    dmPelsHeight As Long                            ''
    dmDisplayFlags As Long                  'See below.
    dmDisplayFrequency As Long              'See 'Help'/'DEVMODE'
    'Only available if WINVER >=400
    dmICMMethod As Long                     'See below.
    dmICMIntent As Long                         ''
    dmMediaType As Long                         ''
    dmDitherType As Long                        ''
    dmReserved1 As Long                     'Not used. MUST = 0
    dmReserved2 As Long                     'Not used. MUST = 0
    'Only available if WINVER >=500
    dmPanningWidth As Long                  'MUST = 0
    dmPanningHeight As Long                 'MUST = 0
End Type

'Standard variables for fields, (dmFields).
Public Enum DMFIELDS
    DM_ORIENTATION = &H1
    DM_PAPERSIZE = &H2
    DM_PAPERLENGTH = &H4
    DM_PAPERWIDTH = &H8
    DM_SCALE = &H10
    DM_POSITION = &H20              'WINVER >= 500
    DM_NUP = &H4                    'WINVER >= 500
    DM_DISPLAYORIENTATION = &H80    'WINVER >= 501
    DM_COPIES = &H100
    DM_DEFAULTSOURCE = &H200
    DM_PRINTQUALITY = &H400
    DM_COLOR = &H800
    DM_DUPLEX = &H1000
    DM_YRESOLUTION = &H2000
    DM_TTOPTION = &H4000
    DM_COLLATE = &H8000
    DM_FORMNAME = &H10000
    DM_LOGPIXELS = &H20000
    DM_BITSPERPEL = &H40000
    DM_PELSWIDTH = &H80000
    DM_PELSHEIGHT = &H100000
    DM_DISPLAYFLAGS = &H200000
    DM_DISPLAYFREQUENCY = &H400000
    DM_ICMMETHOD = &H800000         'WINVER >= 400
    DM_ICMINTENT = &H1000000              ''
    DM_MEDIATYPE = &H2000000              ''
    DM_DITHERTYPE = &H4000000             ''
    DM_PANNINGWIDTH = &H8000000           ''
    DM_PANNINGHEIGHT = &H10000000         ''
    DM_DISPLAYFIXEDOUTPUT = &H20000000  'WINVER >= 501
End Enum

'Standard variables for orientations, (dmOrientation).
Public Enum DMORIENT
    DMORIENT_PORTRAIT = 1
    DMORIENT_LANDSCAPE = 2
End Enum

'Standard variables for paper sizes, (dmPaperSize).
'NB it's unlikely that any one printer will accept all of these codes.
Public Enum DMPAPER
    DMPAPER_LETTER = 1                      'Letter, 8 1/2" x 11"
    DMPAPER_FIRST = DMPAPER_LETTER
    DMPAPER_LETTERSMALL = 2                 'Letter Small, 8 1/2" x 11"
    DMPAPER_TABLOID = 3                     'Tabloid, 11" x 17"
    DMPAPER_LEDGER = 4                      'Ledger, 17" x 11"
    DMPAPER_LEGAL = 5                       'Legal, 8 1/2" x 14"
    DMPAPER_STATEMENT = 6                   'Statement, 5 1/2" x 8 1/2"
    DMPAPER_EXECUTIVE = 7                   'Executive, 7 1/4" x 10 1/2"
    DMPAPER_A3 = 8                          'A3 sheet, 297mm x 420mm
    DMPAPER_A4 = 9                          'A4 Sheet, 210mm x 297mm
    DMPAPER_A4SMALL = 10                    'A4 small sheet, 210mm x 297mm
    DMPAPER_A5 = 11                         'A5 sheet, 148mm x 210mm
    DMPAPER_B4 = 12                         'B4 sheet, 250mm x 354mm
    DMPAPER_B5 = 13                         'B5 sheet, 182mm x 257mm
    DMPAPER_FOLIO = 14                      'Folio, 8 1/2" x 13"
    DMPAPER_QUARTO = 15                     'Quarto, 215mm x 275mm
    DMPAPER_10X14 = 16                      '10" x 14" sheet
    DMPAPER_11X17 = 17                      '11" x 17" sheet
    DMPAPER_NOTE = 18                       'Note, 8 1/2" x 11"
    DMPAPER_ENV_9 = 19                      '#9 Envelope, 3 7/8" x 8 7/8"
    DMPAPER_ENV_10 = 20                     '#10 Envelope, 4 1/8" x 9 1/2"
    DMPAPER_ENV_11 = 21                     '#11 Envelope, 4 1/2" x 10 3/8"
    DMPAPER_ENV_12 = 22                     '#12 Envelope, 4 3/4" x 11"
    DMPAPER_ENV_14 = 23                     '#14 Envelope, 5" x 11 1/2"
    DMPAPER_CSHEET = 24                     'C Sheet, 17" x 22"
    DMPAPER_DSHEET = 25                     'D Sheet, 22" x 34"
    DMPAPER_ESHEET = 26                     'E Sheet, 34" x 44"
    DMPAPER_ENV_DL = 27                     'DL Envelope, 110mm x 220mm
    DMPAPER_ENV_C5 = 28                     'C5 Envelope, 162mm x 229mm
    DMPAPER_ENV_C3 = 29                     'C3 Envelope, 324mm x 458mm
    DMPAPER_ENV_C4 = 30                     'C4 Envelope, 229mm x 324mm
    DMPAPER_ENV_C6 = 31                     'C6 Envelope, 114mm x 162mm
    DMPAPER_ENV_C65 = 32                    'C65 Envelope, 114mm x 229mm
    DMPAPER_ENV_B4 = 33                     'B4 Envelope, 250mm x 353mm
    DMPAPER_ENV_B5 = 34                     'B5 Envelope, 176mm x 250mm
    DMPAPER_ENV_B6 = 35                     'B6 Envelope, 176mm x 125mm
    DMPAPER_ENV_ITALY = 36                  'Italian Envelope, 110mm x 230mm
    DMPAPER_ENV_MONARCH = 37                'Monarch Envelope, 3 7/8" x 7 1/2"
    DMPAPER_ENV_PERSONAL = 38               '6 3/4" Envelope, 3 5/8" x 6 1/2"
    DMPAPER_FANFOLD_US = 39                 'US Std Fanfold, 14 7/8" x 11"
    DMPAPER_FANFOLD_STD_GERMAN = 40         'German Std Fanfold, 8 1/2" x 12"
    DMPAPER_FANFOLD_LGL_GERMAN = 41         'German Legal Fanfold, 8 1/2" x 13"
    'DMPAPER_LAST = DMPAPER_FANFOLD_LGL_GERMAN   'If WINVER < 400
    'If WINVER >= 400 then the following sizes are also available.
    DMPAPER_ISO_B4 = 42                     'B4 (ISO) 250mm x 353mm
    DMPAPER_JAPANESE_POSTCARD = 43          'Japanese Postcard 100mm x 148mm
    DMPAPER_9X11 = 44                       '9" x 11"
    DMPAPER_10X11 = 45                      '10" x 11"
    DMPAPER_15X11 = 46                      '15" x 11"
    DMPAPER_ENV_INVITE = 47                 'Envelope Invite 220mm x 220mm
    DMPAPER_RESERVED_48 = 48    'RESERVED--DO NOT USE
    DMPAPER_RESERVED_49 = 49    'RESERVED--DO NOT USE
    DMPAPER_LETTER_EXTRA = 50               'Letter Extra 9.275" x 12"
    DMPAPER_LEGAL_EXTRA = 51                'Legal Extra 9.275" x 15"
    DMPAPER_TABLOID_EXTRA = 52              'Tabloid Extra 11.69" x 18"
    DMPAPER_A4_EXTRA = 53                   'A4 Extra 9.27" x 12.69"
    DMPAPER_LETTER_TRANSVERSE = 54          'Letter Transverse 8.27" x 11"
    DMPAPER_A4_TRANSVERSE = 55              'A4 Transverse 210mm x 297mm
    DMPAPER_LETTER_EXTRA_TRANSVERSE = 56    'Letter Extra Transverse 9.275" x 12"
    DMPAPER_A_PLUS = 57                     'SuperA/SuperA/A4 227mm x 356mm
    DMPAPER_B_PLUS = 58                     'SuperB/SuperB/A3 305mm x 487mm
    DMPAPER_LETTER_PLUS = 59                'Letter Plus 8.5" x 12.69"
    DMPAPER_A4_PLUS = 60                    'A4 Plus 210mm x 330mm
    DMPAPER_A5_TRANSVERSE = 61              'A5 Transverse 148mm x 210mm
    DMPAPER_B5_TRANSVERSE = 62              'B5 (JIS) Transverse 182mm x 257mm
    DMPAPER_A3_EXTRA = 63                   'A3 Extra 322mm x 445mm
    DMPAPER_A5_EXTRA = 64                   'A5 Extra 174mm x 235mm
    DMPAPER_B5_EXTRA = 65                   'B5 (ISO) Extra 201mm x 276mm
    DMPAPER_A2 = 66                         'A2 420mm x 594 mm
    DMPAPER_A3_TRANSVERSE = 67              'A3 Transverse 297mm x 420mm
    DMPAPER_A3_EXTRA_TRANSVERSE = 68        'A3 Extra Transverse 322mm x 445mm
    'DMPAPER_LAST = DMPAPER_A3_EXTRA_TRANSVERSE  'If WINVER >= 400
    'If WINVER >= 500 then the following sizes are also available.
    DMPAPER_DBL_JAPANESE_POSTCARD = 69      'Double Japanese Postcard, 200 x 148 millimeters
    DMPAPER_A6 = 70                         'A6 sheet, 105 x 148 millimeters
    DMPAPER_JENV_KAKU2 = 71                 'Japanese Envelope Kaku #2
    DMPAPER_JENV_KAKU3 = 72                 'Japanese Envelope Kaku #3
    DMPAPER_JENV_CHOU3 = 73                 'Japanese Envelope Chou #3
    DMPAPER_JENV_CHOU4 = 74                 'Japanese Envelope Chou #4
    DMPAPER_LETTER_ROTATED = 75             'Letter Rotated 11" x 8 1/22 inches
    DMPAPER_A3_ROTATED = 76                 'A3 rotated sheet, 420 x 297 millimeters
    DMPAPER_A4_ROTATED = 77                 'A4 rotated sheet, 297 x 210 millimeters
    DMPAPER_A5_ROTATED = 78                 'A5 rotated sheet, 210 x 148 millimeters
    DMPAPER_B4_JIS_ROTATED = 79             'B4 (JIS) rotated sheet, 364 x 257 millimeters
    DMPAPER_B5_JIS_ROTATED = 80             'B5 (JIS) rotated sheet, 257 x 182 millimeters
    DMPAPER_JAPANESE_POSTCARD_ROTATED = 81  'Japanese Postcard Rotated, 148 x 100 millimeters
    DMPAPER_DBL_JAPANESE_POSTCARD_ROTATED = 82 'Double Japanese Postcard Rotated, 148 x 200 millimeters
    DMPAPER_A6_ROTATED = 83                 'A6 rotated sheet, 148 x 105 millimeters
    DMPAPER_JENV_KAKU2_ROTATED = 84         'Japanese Envelope Kaku #2 Rotated
    DMPAPER_JENV_KAKU3_ROTATED = 85         'Japanese Envelope Kaku #3 Rotated
    DMPAPER_JENV_CHOU3_ROTATED = 86         'Japanese Envelope Chou #3 Rotated
    DMPAPER_JENV_CHOU4_ROTATED = 87         'Japanese Envelope Chou #4 Rotated
    DMPAPER_B6_JIS = 88                     'B6 (JIS) sheet, 128 x 182 millimeters
    DMPAPER_B6_JIS_ROTATED = 89             'B6 (JIS) rotated sheet, 182 x 128 millimeters
    DMPAPER_12X11 = 90                      '12" x 11" sheet
    DMPAPER_JENV_YOU4 = 91                  'Japanese Envelope You #4
    DMPAPER_JENV_YOU4_ROTATED = 92          'Japanese Envelope You #4 Rotated
    DMPAPER_P16K = 93                       'PRC 16K, 146 x 215 millimeters
    DMPAPER_P32K = 94                       'PRC 32K, 97 x 151 millimeters
    DMPAPER_P32KBIG = 95                    'PRC 32K(Big) 97 x 151 millimeters
    DMPAPER_PENV_1 = 96                     'PRC Envelope #1, 102 x 165 millimeters
    DMPAPER_PENV_2 = 97                     'PRC Envelope #2, 102 x 176 millimeters
    DMPAPER_PENV_3 = 98                     'PRC Envelope #3, 125 x 176 millimeters
    DMPAPER_PENV_4 = 99                     'PRC Envelope #4, 110 x 208 millimeters
    DMPAPER_PENV_5 = 100                    'PRC Envelope #5, 110 x 220 millimeters
    DMPAPER_PENV_6 = 101                    'PRC Envelope #6, 120 x 230 millimeters
    DMPAPER_PENV_7 = 102                    'PRC Envelope #7, 160 x 230 millimeters
    DMPAPER_PENV_8 = 103                    'PRC Envelope #8, 120 x 309 millimeters
    DMPAPER_PENV_9 = 104                    'PRC Envelope #9, 229 x 324 millimeters
    DMPAPER_PENV_10 = 105                   'PRC Envelope #10, 324 x 458 millimeters
    DMPAPER_P16K_ROTATED = 106              'PRC 16K Rotated, 215 x 146 millimeters
    DMPAPER_P32K_ROTATED = 107              'PRC 32K Rotated, 151 x 97 millimeters
    DMPAPER_P32KBIG_ROTATED = 108           'PRC 32K(Big) Rotated, 151 x 97 millimeters
    DMPAPER_PENV_1_ROTATED = 109            'PRC Envelope #1 Rotated, 165 x 102 millimeters
    DMPAPER_PENV_2_ROTATED = 110            'PRC Envelope #2 Rotated, 176 x 102 millimeters
    DMPAPER_PENV_3_ROTATED = 111            'PRC Envelope #3 Rotated, 176 x 125 millimeters
    DMPAPER_PENV_4_ROTATED = 112            'PRC Envelope #4 Rotated, 208 x 110 millimeters
    DMPAPER_PENV_5_ROTATED = 113            'PRC Envelope #5 Rotated, 220 x 110 millimeters
    DMPAPER_PENV_6_ROTATED = 114            'PRC Envelope #6 Rotated, 230 x 120 millimeters
    DMPAPER_PENV_7_ROTATED = 115            'PRC Envelope #7 Rotated, 230 x 160 millimeters
    DMPAPER_PENV_8_ROTATED = 116            'PRC Envelope #8 Rotated, 309 x 120 millimeters
    DMPAPER_PENV_9_ROTATED = 117            'PRC Envelope #9 Rotated, 324 x 229 millimeters
    DMPAPER_PENV_10_ROTATED = 118           'PRC Envelope #10 Rotated, 458 x 324 millimeters
    DMPAPER_LAST = DMPAPER_PENV_10_ROTATED
    DMPAPER_USER = 256                      'Device-specific papers start from here.
End Enum

'WINVER values, NT = 400, 2000 = 500, XP = 501, Vista = 600

'As well as the above, there are a number of codes used by specific printers for custom
'paper sizes which don't have, (or I've not found!), a DMPAPER_ variable name.

'PRINTER: Canon Pixma iP 4200
    '119            2L                          127 x 178mm
    '120            4" x 6"
    '121            5" x 7"
    '122            8" x 10"
    '123            L                           89 x 127mm
    '124            A4+ scaled
    '125            Japanese Envelope You #6    98 x 190mm
    '126            Credit card 2
    '127            Card 2
    '128            P                           89 x 254mm
    
'PRINTER:   Magicolor 2200
    '257            B5 ISO
    '258            UK Quarto
    '260            SP Folio
    '261            GT postcard

'Standard variables for paper source bins, (dmDefaultSource).
Public Enum DMBIN
    DMBIN_UPPER = 1         'Multi-purpose' for Magicolor!
    DMBIN_ONLYONE = 1
    DMBIN_LOWER = 2         'Upper' for Magicolor!
    DMBIN_MIDDLE = 3
    DMBIN_MANUAL = 4
    DMBIN_ENVELOPE = 5
    DMBIN_ENVMANUAL = 6
    DMBIN_AUTO = 7          'Auto' for Magicolor.
    DMBIN_TRACTOR = 8
    DMBIN_SMALLFMT = 9
    DMBIN_LARGEFMT = 10
    DMBIN_LARGECAPACITY = 11
    DMBIN_CASSETTE = 14
    DMBIN_FORMSOURCE = 15
    DMBIN_USER = 256        'Device specific values start here.
End Enum

'PRINTER: Canon Pixma iP 4200
    '263            Disc tray
    '267            Cassette
    '268            Paper feed switch
    '269            Continuous auto feed
    '270            Paper allocation

'Standard variables for print quality, (dmPrintQuality).
Public Enum DMRES
    DMRES_DRAFT = -1
    DMRES_LOW = -2
    DMRES_MEDIUM = -3
    DMRES_HIGH = -4
End Enum

'Standard variables for print quality, (dmColor).
Public Enum dmColor
    DMCOLOR_MONOCHROME = 1
    DMCOLOR_COLOR = 2
End Enum

'Standard variables for duplex printing, (if supported), (dmDuplex).
Public Enum DMDUP
    DMDUP_SIMPLEX = 1
    DMDUP_VERTICAL = 2
    DMDUP_HORIZONTAL = 3
End Enum

'Standard variables to specify how TrueType fonts are printed, (dmTTOption).
Public Enum DMTT
    DMTT_BITMAP = 1     'Prints TrueType fonts as graphics. This is the default action for dot-matrix
                        'printers.
    DMTT_DOWNLOAD = 2   'Downloads TrueType fonts as soft fonts. This is the default action for
                        'Hewlett-Packard printers that use Printer Control Language (PCL).
    DMTT_SUBDEV = 3     'Substitute device fonts for TrueType fonts. This is the default action for
                        'PostScript printers.
End Enum

'Standard variables to specify collation, (dmCollate).
Public Enum DMCOLLATE
    DMCOLLATE_FALSE = 0
    DMCOLLATE_TRUE = 1
End Enum

'Standard variables for the display mode, (dmDisplayFlags).
Public Enum DMDISFLAGS
    DM_GRAYSCALE = 1    'Specifies that the display is a noncolor device. If this flag is not set,
                        'color is assumed.
    DM_INTERLACED = 2   'Specifies that the display mode is interlaced. If the flag is not set,
                        'noninterlaced is assumed.
End Enum

'Standard variables to specify how ICM is handled, (dmICMMethod).
Public Enum DMICMMETH
    DMICMMETHOD_NONE = 1    'Specifies that ICM is disabled.
    DMICMMETHOD_SYSTEM = 2  'Specifies that ICM is handled by Windows.
    DMICMMETHOD_DRIVER = 3  'Specifies that ICM is handled by the device driver.
    DMICMMETHOD_DEVICE = 4  'Specifies that ICM is handled by the destination device.
End Enum

'Standard variables to specify which of the three color matching methods is used, (dmICMIntent).
Public Enum DMICM
    DMICM_SATURATE = 1      'Color matching should optimize for color saturation. This value is the
                            'most appropriate choice for business graphs when dithering is not desired.
    DMICM_CONTRAST = 2      'Color matching should optimize for color contrast. This value is the most
                            'appropriate choice for scanned or photographic images when dithering is
                            'desired.
    DMICM_COLORMETRIC = 3   'Color matching should optimize to match the exact color requested. This
                            'value is most appropriate for use with business logos or other images when
                            'an exact color match is desired.
End Enum

'Standard variables to specify the type of media, (dmMediaType).
Public Enum DMMEDIA
    DMMEDIA_STANDARD = 1        'Plain paper.
    DMMEDIA_GLOSSY = 2          'Glossy paper
    DMMEDIA_TRANSPARENCY = 3    'Transparent film
    DMMEDIA_USER = 256          'Custom values start from here, (Thick media, Labels, etc.)
End Enum

'PRINTER: Canon Pixma iP 4200
    '262            Hagaki.
    '263            Envelope.
    '271            High Resolution Paper.
    '273            T-shirt Transfers.
    '277            Glossy Photo Paper.
    '281            Photo Paper Pro.
    '283            Ink Jet Hagaki.
    '284            Matte Photo Paper.
    '285            Photo Paper Plus Glossy.
    '287            Printable Disc (Recommended).
    '288            Printable Disc (Other).
    '291            Other Photo Paper.
    '292            Photo Paper Plus, double sided.
     
'Standard variables to specify the dither type, (dmDitherType).
Public Enum DMDITHER
    DMDITHER_NONE = 1       'No dithering.
    DMDITHER_COARSE = 2     'Dithering with a coarse brush.
    DMDITHER_FINE = 3       'Dithering with a fine brush.
    DMDITHER_LINEART = 4    'Line art dithering, a special dithering method that produces well defined
                            'borders between black, white, and gray scalings.
                            'It is not suitable for images that include continuous graduations in
                            'intensisty and hue such as scanned photographs.
    DMDITHER_GRAYSCALE = 5  'Device does grayscaling.
End Enum

'****** DATA  USED TO SET A SELECTED PRINTER AS THE DEFAULT *****

Private Const HWND_BROADCAST = &HFFFF
Private Const WM_WININICHANGE = &H1A

'Constants for DesiredAccess member of PRINTER_DEFAULTS
Private Const STANDARD_RIGHTS_REQUIRED = &HF0000
Private Const PRINTER_ACCESS_ADMINISTER = &H4
Private Const PRINTER_ACCESS_USE = &H8
Private Const PRINTER_ALL_ACCESS = (STANDARD_RIGHTS_REQUIRED Or PRINTER_ACCESS_ADMINISTER Or PRINTER_ACCESS_USE)

'Constant that goes into PRINTER_INFO_5 Attributes member to set it as default
Private Const PRINTER_ATTRIBUTE_DEFAULT = 4

'Constant for OSVERSIONINFO.dwPlatformId
Private Const VER_PLATFORM_WIN32_WINDOWS = 1

Private Type OSVERSIONINFO
    dwOSVersionInfoSize As Long
    dwMajorVersion As Long
    dwMinorVersion As Long
    dwBuildNumber As Long
    dwPlatformId As Long
    szCSDVersion As String * 128
End Type

Private Type PRINTER_INFO_5
     pPrinterName As String
     pPortName As String
     Attributes As Long
     DeviceNotSelectedTimeout As Long
     TransmissionRetryTimeout As Long
End Type

Private Type PRINTER_INFO_8
     pDevMode As Long
End Type

Private Type PRINTER_DEFAULTS
     pDatatype As Long
     pDevMode As Long
     DesiredAccess As Long
End Type

'==============================================================================================
'PAGE SETUP DIALOG.

Private Type POINTAPI
    x As Long
    y As Long
End Type

Private Type RECT
    Left As Long
    Top As Long
    Right As Long
    Bottom As Long
End Type

Private Type PAGESETUPDLG
    lStructSize As Long
    hwndOwner As Long
    hDevMode As Long
    hDevNames As Long
    flags As Long
    ptPaperSize As POINTAPI
    rtMinMargin As RECT
    rtMargin As RECT
    hInstance As Long
    lCustData As Long
    lpfnPageSetupHook As Long
    lpfnPagePaintHook As Long
    lpPageSetupTemplateName As String
    hPageSetupTemplate As Long
End Type

'Array for the return of the margins and paper width & height.
Private p_data(6) As Single '0 = LEFT MARGIN, 1 = RIGHT MARGIN, 2 = TOP MARGIN,
                            '3 = BOTTOM MARGIN, 4 = PAPER WIDTH, 5 = PAPER HEIGHT.
                            '6 = mm/" flag, (0, 1)
'==============================================================================================
'SELECT COLOUR

Private Type CHOOSECOLOR
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    rgbResult As Long
    lpCustColors As String
    flags As Long
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type

'==============================================================================================
'FONT SELECTION

Private Type CHOOSEFONT
        lStructSize As Long
        hwndOwner As Long
        hDC As Long
        lpLogFont As Long
        iPointSize As Long
        flags As Long
        rgbColors As Long
        lCustData As Long
        lpfnHook As Long
        lpTemplateName As String
        hInstance As Long
        lpszStyle As String
        nFontType As Integer
        MISSING_ALIGNMENT As Integer    'Never set this variable. It is there only to align the other
                                        'members of the structure in memory.
        nSizeMin As Long
        nSizeMax As Long
End Type

'Standard variables for font types, (nFontType).
Public Enum FONTTYPE
    BOLD_FONTTYPE = &H100
    ITALIC_FONTTYPE = &H200
    PRINTER_FONTTYPE = &H4000
    REGULAR_FONTTYPE = &H400
    SCREEN_FONTTYPE = &H2000
    SIMULATED_FONTTYPE = &H8000
End Enum

'Font display defaults.
Private Const def_font = "Century Gothic" & vbNullChar      'String must be null-terminated.
Private Const pt_sz = 120       'Initial point size in 1/10th pts.
Private Const sz_min = 10       'Minimum point size.
Private Const sz_max = 72       'Maximum point size.

'Variables for returned data.
Private font_name As String
Private font_size As Integer
Private font_bold As Boolean
Private font_italic As Boolean
Private font_underline As Boolean
Private font_strikeout As Boolean
Private font_colour As Long
Private font_weight As String

Private Type LOGFONT
        lfHeight As Long        'See 'Help/LOGFONT' for data.
        lfWidth As Long                     ''
        lfEscapement As Long                ''
        lfOrientation As Long               ''
        lfWeight As Long        'See below for data.
        lfItalic As Byte        'Boolean, TRUE = Italic, etc.
        lfUnderline As Byte         ''
        lfStrikeOut As Byte         ''
        lfCharSet As Byte           'See below for data.
        lfOutPrecision As Byte              ''
        lfClipPrecision As Byte             ''
        lfQuality As Byte                   ''
        lfPitchAndFamily As Byte            ''
        lfFaceName As String * 31   'See 'Help/LOGFONT' for data.
End Type

'Standard variables for font weights, (lfWeight).
Public Enum LFWT
    FW_DONTCARE = 0
    FW_THIN = 100
    FW_EXTRALIGHT = 200
    FW_ULTRALIGHT = 200
    FW_LIGHT = 300
    FW_NORMAL = 400
    FW_REGULAR = 400
    FW_MEDIUM = 0
    FW_SEMIBOLD = 600
    FW_DEMIBOLD = 600
    FW_BOLD = 700
    FW_EXTRABOLD = 800
    FW_ULTRABOLD = 800
    FW_HEAVY = 900
    FW_BLACK = 900
End Enum

'Standard variables for character sets, (lfCharSet).
Public Enum LFCHAR
    ARABIC_CHARSET = 178
    ANSI_CHARSET = 0
    BALTIC_CHARSET = 186
    CHINESEBIG5_CHARSET = 136
    DEFAULT_CHARSET = 1
    EASTEUROPE_CHARSET = 238
    GB2312_CHARSET = 134
    GREEK_CHARSET = 161
    HANGUL_CHARSET = 129
    HEBREW_CHARSET = 177
    JOHAB_CHARSET = 130
    MAC_CHARSET = 77
    OEM_CHARSET = 255
    RUSSIAN_CHARSET = 204
    SHIFTJIS_CHARSET = 128
    SYMBOL_CHARSET = 2
    THAI_CHARSET = 222
    TURKISH_CHARSET = 162
End Enum

'Standard variables for output precision, (lfOutPrecision).
Public Enum LFOUT
    OUT_CHARACTER_PRECIS = 2
    OUT_DEFAULT_PRECIS = 0
    OUT_DEVICE_PRECIS = 5
    OUT_OUTLINE_PRECIS = 8
    OUT_RASTER_PRECIS = 6
    OUT_STRING_PRECIS = 1
    OUT_STROKE_PRECIS = 3
    OUT_TT_ONLY_PRECIS = 7
    OUT_TT_PRECIS = 4
    OUT_SCREEN_OUTLINE_PRECIS = 9
End Enum

'Standard variables for cliping precision, (lfClipPrecision).
Public Enum LFCLIP
    CLIP_CHARACTER_PRECIS = 1
    CLIP_DEFAULT_PRECIS = 0
    CLIP_EMBEDDED = 128
    CLIP_LH_ANGLES = 16
    CLIP_MASK = 15
    CLIP_STROKE_PRECIS = 2
    CLIP_TT_ALWAYS = 32
End Enum

'Standard variables for output quality, (lfQuality).
Public Enum LFQUAL
    DEFAULT_QUALITY = 0
    DRAFT_QUALITY = 1
    PROOF_QUALITY = 2
End Enum

'Standard variables for pitch and family, (lfPitchAndFamily).
'Bits 0 & 1 define the pitch; bits 4 to 7, the quality.
Public Enum LFPITCH         'Binary
    DEFAULT_PITCH = 0       '------00
    FIXED_PITCH = 1         '------01
    VARIABLE_PITCH = 2      '------10
    FF_DONTCARE = 0         '000000--
    FF_ROMAN = 16           '000100--
    FF_SWISS = 32           '001000--
    FF_MODERN = 48          '001100--
    FF_SCRIPT = 64          '010000--
    FF_DECORATIVE = 80      '010100--
End Enum

'API function declarations.
Private Declare Function CHOOSECOLOR Lib "comdlg32.dll" Alias "ChooseColorA" (pChoosecolor As CHOOSECOLOR) As Long
Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long
Private Declare Function GetSaveFileName Lib "comdlg32.dll" Alias "GetSaveFileNameA" (pOpenfilename As OPENFILENAME) As Long
Private Declare Function PrintDialog Lib "comdlg32.dll" Alias "PrintDlgA" (pPrintdlg As PRINTDLG_TYPE) As Long
Private Declare Function PAGESETUPDLG Lib "comdlg32.dll" Alias "PageSetupDlgA" (pPagesetupdlg As PAGESETUPDLG) As Long
Private Declare Function CHOOSEFONT Lib "comdlg32.dll" Alias "ChooseFontA" (pChoosefont As CHOOSEFONT) As Long
Private Declare Sub CopyMemoryDMBase Lib "kernel32" Alias "RtlMoveMemory" (Destination As DEVMODE_TYPE, ByVal Source As Long, ByVal Length As Long)
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (hpvDest As Any, hpvSource As Any, ByVal cbCopy As Long)
Private Declare Sub CopyMemoryFromDMBase Lib "kernel32" Alias "RtlMoveMemory" (ByVal Destination As Long, Source As DEVMODE_TYPE, ByVal Length As Long)
Private Declare Function GlobalLock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalUnlock Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function GlobalAlloc Lib "kernel32" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Private Declare Function GlobalFree Lib "kernel32" (ByVal hMem As Long) As Long
Private Declare Function CommDlgExtendedError Lib "comdlg32.dll" () As Long
Private Declare Function GetProfileString Lib "kernel32" Alias "GetProfileStringA" (ByVal lpAppName As String, ByVal lpKeyName As String, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long) As Long
Private Declare Function WriteProfileString Lib "kernel32" Alias "WriteProfileStringA" (ByVal lpszSection As String, ByVal lpszKeyName As String, ByVal lpszString As String) As Long
Private Declare Function SendMessage Lib "user32" Alias "SendMessageA" (ByVal hwnd As Long, ByVal wMsg As Long, ByVal wParam As Long, lparam As String) As Long
Private Declare Function GetVersionExA Lib "kernel32" (lpVersionInformation As OSVERSIONINFO) As Integer
Private Declare Function OpenPrinter Lib "winspool.drv" Alias "OpenPrinterA" (ByVal pPrinterName As String, phPrinter As Long, pDefault As PRINTER_DEFAULTS) As Long
Private Declare Function SetPrinter Lib "winspool.drv" Alias "SetPrinterA" (ByVal hPrinter As Long, ByVal Level As Long, pPrinter As Any, ByVal Command As Long) As Long
Private Declare Function GetPrinter Lib "winspool.drv" Alias "GetPrinterA" (ByVal hPrinter As Long, ByVal Level As Long, pPrinter As Any, ByVal cbBuf As Long, pcbNeeded As Long) As Long
Private Declare Function lstrcpy Lib "kernel32" Alias "lstrcpyA" (ByVal lpString1 As String, ByVal lpString2 As Any) As Long
Private Declare Function ClosePrinter Lib "winspool.drv" (ByVal hPrinter As Long) As Long

Dim OFName As OPENFILENAME
Dim CustomColors() As Byte

Private OS_version As Long          'OS version code,
Private errcode As Long             'Error code.

Private make_default As Boolean     'Flag to make a selected printer the default.
Private in_existance As Boolean     'CD object constructed flag.

'Object constructor.
'Run when an object is created.

Private Sub Class_Initialize()

    Static in_existance As Boolean    'Flag for object exits, (only one allowed.)

    If Not in_existance Then
        'Redim the variables to store the custom colors
        ReDim CustomColors(0 To 16 * 4 - 1) As Byte
        Dim i As Integer
        For i = LBound(CustomColors) To UBound(CustomColors)
            CustomColors(i) = 0
        Next i
        
        make_default = True 'Set the Make Default flag true as the default.
        
        in_existance = True 'Flag that an instance of the class exists.
    End If
    
End Sub

'Procedure name:    Class_Terminate()
'Run when a page is terminated.

Private Sub Class_Terminate()

    in_existance = False    'Clear the existance flag.
 
End Sub

'Routine to return the name of a file to be OPENed.
'Function name: ShowOpen(ByVal huke As Long, filters as string, flgs as long, title as string,
'                        byval idir as string)
'Parameters:    huke;       hook,
'               filters;    required filter string,
'               flgs;       process flags,
'               title;      window title,
'               idir;       initial directory.

'NB A list of files is delimited by CRs so these need to be removed before
'   the string is used to open the files concerned.
'   A single file is stripped before the text is returned.

Public Function ShowOpen(ByVal huke As Long, filters, flgs, title, ByVal idir As String)
 
    Dim sOpen As SelectedFile
    Dim Count, f_sel As Integer
    Dim FileList As String
    
    canceled = False    'Clear the 'Canceled' flag and
    
    OFName.lpstrFilter = filters    'File type filters.
    'See CommonDialog Flags for all options
    OFName.flags = flgs             'Device flags.
    OFName.lpstrTitle = title       'Window title.
    OFName.lpstrInitialDir = idir   'Initial directory.
 
    sOpen = ShwOpen(huke)           'Call API routine.
    
    If Err.Number <> 32755 And sOpen.bCanceled = False Then 'it's OK.
        f_sel = sOpen.nFilesSelected    'Store the number of files selected
        If f_sel > 1 Then 'several files have been selected, so
            FileList = sOpen.sLastDirectory & vbCr      'initialise the file list with the path string.
            For Count = 1 To sOpen.nFilesSelected                   'Use a loop
                FileList = FileList & sOpen.sFiles(Count) & vbCr    'to add the file names
            Next Count                                              'to the list and
            ShowOpen = FileList                                     'return the names.
        Else                                           'Otherwise, it's a single file, so
            FileList = Replace(OFName.lpstrFile, Chr(0), "")    'remove the Chr(0)'s,
            FileList = Trim(FileList)                           'trailing spaces and
            ShowOpen = Replace(FileList, Chr(13), "")           'CR's before returning the string.
        End If
    Else                                        'There was an error, so
        errcode = CommDlgExtendedError()        'get the error code and,
        If errcode <> 0 Then                    'if it wasn't a CANCEL,
            error_message "ShowOpen", errcode  'display the error message.
        End If
        canceled = True     'In case of error or a user CANCEL set the CANCELed flag and
        ShowOpen = ""       'return an empty string as an error indicator.
    End If
    
 End Function

'Routine that actually makes the API call.
Private Function ShwOpen(ByVal hwnd As Long) As SelectedFile

    Dim ret As Long                     'API returned value.
    Dim Count As Integer                'File count.
    Dim fd_t As String                  'File title.
    Dim LastCharacter As Integer
    Dim NewCharacter As Integer
    Dim tempFiles(1 To 200) As String   'Temporary file array
    
    On Error Resume Next
    
    OFName.lStructSize = Len(OFName)    'Populate the Open File Name structure.
    OFName.hwndOwner = hwnd
    OFName.lpstrFileTitle = Space$(2048)
    OFName.nMaxFileTitle = Len(OFName.lpstrFileTitle)
    'OFName.lpstrFile = OFName.lpstrFile & Space$(2047) & Chr$(0)
    OFName.lpstrFile = Space$(2047) & Chr$(0)
    OFName.nMaxFile = Len(OFName.lpstrFile)

    ret = GetOpenFileName(OFName)       'API call.

    If ret Then
        fd_t = Trim$(OFName.lpstrFileTitle)
        If fd_t = "" Or fd_t = Chr(0) Then 'a GROUP of files has been selected.
            LastCharacter = 0
            Count = 0
            'Use a loop to read the selected file names into the 'tempFiles()' array.
            While ShwOpen.nFilesSelected = 0
                NewCharacter = InStr(LastCharacter + 1, OFName.lpstrFile, Chr$(0), vbTextCompare)
                If Count > 0 Then
                    tempFiles(Count) = Mid(OFName.lpstrFile, LastCharacter + 1, NewCharacter - LastCharacter - 1)
                Else
                    ShwOpen.sLastDirectory = Mid(OFName.lpstrFile, LastCharacter + 1, NewCharacter - LastCharacter - 1)
                End If
                Count = Count + 1
                If InStr(NewCharacter + 1, OFName.lpstrFile, Chr$(0), vbTextCompare) = InStr(NewCharacter + 1, OFName.lpstrFile, Chr$(0) & Chr$(0), vbTextCompare) Then
                    tempFiles(Count) = Mid(OFName.lpstrFile, NewCharacter + 1, InStr(NewCharacter + 1, OFName.lpstrFile, Chr$(0) & Chr$(0), vbTextCompare) - NewCharacter - 1)
                    ShwOpen.nFilesSelected = Count
                End If
                LastCharacter = NewCharacter
            Wend
            ReDim ShwOpen.sFiles(1 To ShwOpen.nFilesSelected)
            For Count = 1 To ShwOpen.nFilesSelected
                ShwOpen.sFiles(Count) = tempFiles(Count)
            Next
        Else
            ReDim ShwOpen.sFiles(1 To 1)
            ShwOpen.sLastDirectory = Left$(OFName.lpstrFile, OFName.nFileOffset)
            ShwOpen.nFilesSelected = 1
            ShwOpen.sFiles(1) = Mid(OFName.lpstrFile, OFName.nFileOffset + 1, InStr(1, OFName.lpstrFile, Chr$(0), vbTextCompare) - OFName.nFileOffset - 1)
        End If

        ShwOpen.bCanceled = False
        Exit Function
    Else
        ShwOpen.sLastDirectory = ""
        ShwOpen.nFilesSelected = 0
        ShwOpen.bCanceled = True
        Erase ShwOpen.sFiles
        Exit Function
    End If
    
End Function

'Routine to return the name of a file to be SAVEd.
'Function name: ShowSave(ByVal huke As Long, ByVal filter As String, ByVal ext_txt As String,
'                        ByVal flgs As Long, ByVal title As String, ByVal idir As String
'                        ByVal def_fn as string)As String

'Parameters:    huke;       hook,
'               filter;     required filter string,
'               ext_txt;    default extension text, (needed if default filter isn't 1st.),
'               flgs;       process flags,
'               title;      window title,
'               idir;       initial directory,
'               def_fn;     default file name, (optional = "").

Public Function ShowSave(ByVal huke As Long, ByVal filter As String, _
                         ByVal ext_txt As String, ByVal flgs As Long, _
                         ByVal title As String, ByVal idir As String, _
                         Optional ByVal def_fn As String = "") As String

    Dim n_buff As String
    
    If def_fn = "" Then
        n_buff = Space$(254)
    Else
        n_buff = def_fn + Space$(254 - Len(def_fn))
    End If
    
    On Error Resume Next
    
    canceled = False                    'Clear the canceled flag.
    
    OFName.lStructSize = Len(OFName)    'Set the structure size.
    OFName.hwndOwner = huke             'Set the owner window.
    OFName.hInstance = App.hInstance    'Set the application's instance
    OFName.lpstrFilter = filter         'Set the filter
    OFName.lpstrFile = n_buff           'Create a buffer
    OFName.nMaxFile = 255               'Set the maximum number of chars
    OFName.lpstrFileTitle = Space$(254) 'Create a buffer
    OFName.nMaxFileTitle = 255          'Set the maximum number of chars
    OFName.lpstrInitialDir = idir       'Set the initial directory
    OFName.lpstrDefExt = ext_txt        'Set the default extension.
    OFName.lpstrTitle = title           'Set the window title
    OFName.flags = flgs                 'Set the flags

    'Show the 'Save File'dialog
    If GetSaveFileName(OFName) Then 'it's OK, so
        ShowSave = Trim$(OFName.lpstrFile)  'return the file name.
    Else                                        'Otherwise, there was an error, so
        errcode = CommDlgExtendedError()        'get the error code and,
        If errcode <> 0 Then                    'if it wasn't a CANCEL,
            error_message "ShowSave", errcode   'display the error message.
        End If
        canceled = True     'In case of error or a user CANCEL set the CANCELed flag and
        ShowSave = ""       'return an empty string as an error indicator.
    End If
    
End Function

'Routine to display the PRINTER window.
'Procedure name:    ShowPrinter(ByVal huke, ByVal flgs As Long)
'Parameters;        huke;       hook,
'                   lgs;        flags.

Public Sub ShowPrinter(ByVal huke, ByVal flgs As Long)

    'Code by Donald Grover
    Dim PrintDlg As PRINTDLG_TYPE
    Dim DevMode As DEVMODE_TYPE
    Dim DevName As DEVNAMES_TYPE

    Dim lpDevMode As Long, lpDevName As Long
    Dim bReturn As Integer
    Dim objPrinter As Printer, NewPrinterName As String

    Dim MediaType
    
    canceled = False 'Clear the CANCELed flag.
    
    'Use PrintDialog to get the handle to a memory
    'block with DevMode and DevName structures.
    PrintDlg.lStructSize = Len(PrintDlg)
    PrintDlg.hwndOwner = huke

    PrintDlg.flags = flgs
 
    On Error Resume Next
    'Set the current orientation and duplex setting
    DevMode.dmDeviceName = Printer.DeviceName
    DevMode.dmSize = Len(DevMode)
    DevMode.DMFIELDS = DM_ORIENTATION Or DM_DUPLEX
    DevMode.dmPaperWidth = Printer.Width
    DevMode.dmOrientation = Printer.Orientation
    DevMode.dmPaperSize = Printer.PaperSize
    DevMode.dmDuplex = Printer.Duplex
    On Error GoTo 0

    'Allocate memory for the initialization hDevMode structure
    'and copy the settings gathered above into this memory
    PrintDlg.hDevMode = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(DevMode))
    lpDevMode = GlobalLock(PrintDlg.hDevMode)
    If lpDevMode > 0 Then
        CopyMemory ByVal lpDevMode, DevMode, Len(DevMode)
        bReturn = GlobalUnlock(PrintDlg.hDevMode)
    End If
 
    'Set the current driver, device, and port name strings
    With DevName
        .wDriverOffset = 8
        .wDeviceOffset = .wDriverOffset + 1 + Len(Printer.DriverName)
        .wOutputOffset = .wDeviceOffset + 1 + Len(Printer.Port)
        .wDefault = 0
    End With

    With Printer
        DevName.extra = .DriverName & Chr(0) & .DeviceName & Chr(0) & .Port & Chr(0)
    End With
 
    'Allocate memory for the initial hDevName structure
    'and copy the settings gathered above into this memory
    PrintDlg.hDevNames = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(DevName))
    lpDevName = GlobalLock(PrintDlg.hDevNames)
    If lpDevName > 0 Then
        CopyMemory ByVal lpDevName, DevName, Len(DevName)
        bReturn = GlobalUnlock(lpDevName)
    End If
 
    'Call the print dialog up and let the user make changes
    If PrintDialog(PrintDlg) <> 0 Then 'it's Ok, so
        'First get the DevName structure.
        lpDevName = GlobalLock(PrintDlg.hDevNames)
        CopyMemory DevName, ByVal lpDevName, 100
        bReturn = GlobalUnlock(lpDevName)
        GlobalFree PrintDlg.hDevNames

        'Next get the DevMode structure and set the printer
        'properties appropriately
        lpDevMode = GlobalLock(PrintDlg.hDevMode)
        CopyMemory DevMode, ByVal lpDevMode, Len(DevMode)
        bReturn = GlobalUnlock(PrintDlg.hDevMode)
        GlobalFree PrintDlg.hDevMode
 
        NewPrinterName = UCase$(Left(DevMode.dmDeviceName, InStr(DevMode.dmDeviceName, Chr$(0)) - 1))
        
        If Printer.DeviceName <> NewPrinterName Then
            For Each objPrinter In Printers
                If UCase$(objPrinter.DeviceName) = NewPrinterName Then
                    If make_default Then 'set the selected printer as the default.
                        set_default NewPrinterName
                    End If
                    If canceled Then
                        Exit Sub
                    Else
                        Set Printer = objPrinter    'Set the required printer and
                        Printer.TrackDefault = True 'allow the printer to accept the changes.
                    End If
                End If
            Next
        End If
 
        On Error Resume Next
        
        'Set printer object properties according to selections made by user.
        'NB these are NOT stored and ONLY APPLY to this application.
        Printer.Copies = DevMode.dmCopies
        Printer.Duplex = DevMode.dmDuplex
        Printer.Orientation = DevMode.dmOrientation
        Printer.PaperSize = DevMode.dmPaperSize
        Printer.PrintQuality = DevMode.dmPrintQuality
        Printer.ColorMode = DevMode.dmColor
        Printer.PaperBin = DevMode.dmDefaultSource
        
        MediaType = DevMode.dmMediaType 'This must just be stored for use below as it
                                        'isn't a property of the printer object.
      
        'If the Make Default flag is set then the above printer properties
        'are set as global defaults.
        If make_default Then
            make_changes_global NewPrinterName, MediaType
        End If
  
        On Error GoTo 0
    Else                                            'Otherwise, there was an error, so
        errcode = CommDlgExtendedError()            'get the error code and,
        If errcode <> 0 Then                        'if it wasn't a CANCEL,
            error_message "ShowPrinter", errcode    'display the error message.
        End If
        canceled = True         'In case of error or a user CANCEL set the CANCELed flag.
    End If
    
End Sub

'Routine to change the make_default flag.
'Property name: default_flag(d_flg)
'Parameter:     d_flag; Boolean flag value.

Public Property Let default_flag(d_flg)

    make_default = d_flg    'Sets the Class flag.
    
End Property

'Routine to set a selected printer as the default.
'Procedure name:    set_default n_p_n
'Parameter:         n_p_n;  the new printer's name.

'The operation is different depending on whether the OS is pre- or post- NT. This means
'that the OS versions has to be found.

Private Sub set_default(ByVal n_p_n As String)

    OS_version = get_OS_version 'Find which OS is in use.
    
    If OS_version = VER_PLATFORM_WIN32_WINDOWS Then 'this is Win95, etc., so
        Win95SetDefaultPrinter n_p_n                'use the Win95 form.
    Else
    'This assumes that future versions of Windows use the NT method.
        WinNTSetDefaultPrinter n_p_n    'Otherwise, use the WinNT form.
    End If

End Sub

'Routine to find the OS system in use.
'Function name:  get_OS_version

Private Function get_OS_version() As Long

    Dim osinfo As OSVERSIONINFO 'Define the OS version information data block.
    Dim retvalue As Integer

    osinfo.dwOSVersionInfoSize = 148    'Define the information buffer size and
    osinfo.szCSDVersion = Space$(128)   'space for the version string.
    retvalue = GetVersionExA(osinfo)    'Call the GetVersion API.
    
    get_OS_version = osinfo.dwPlatformId    'Return the ID.

End Function

'Routine to set the default printer on Win 95 type systems.
'Procedure name:    Win95SetDefaultPrinter(ByVal PrinterName as string)

Private Sub Win95SetDefaultPrinter(ByVal PrinterName As String)

    Dim Handle As Long          'Handle to printer
    Dim pd As PRINTER_DEFAULTS
    Dim x As Long
    Dim need As Long            'Bytes needed
    Dim pi5 As PRINTER_INFO_5   'The PRINTER_INFO structure
    Dim LastError As Long

    'Set the PRINTER_DEFAULTS members
    pd.pDatatype = 0&
    pd.DesiredAccess = PRINTER_ALL_ACCESS Or pd.DesiredAccess

    'Get a handle to the printer
    x = OpenPrinter(PrinterName, Handle, pd)
    
    If x = False Then 'it failed the Open command.
        'error handler code goes here
        canceled = True     'Set the Canceled flag and
        Exit Sub            'QUIT.
    End If

    'Make an initial call to GetPrinter, requesting Level 5
    '(PRINTER_INFO_5) information, to determine how many bytes you need
    x = GetPrinter(Handle, 5, ByVal 0&, 0, need)
    'No need to check for errors as it's supposed to fail
    'with a 122, ERROR_INSUFFICIENT_BUFFER. code
    'The required size of buffer is in 'need' so redim t accordingly.
    ReDim t((need \ 4)) As Long

    'Call the GetPrinter API for real this time,
    x = GetPrinter(Handle, 5, t(0), need, need)
    If x = False Then   'this is a real GetPrinter failure, so
        errcode = CommDlgExtendedError()
        If errcode <> 0 Then                        'if it wasn't a CANCEL,
            error_message "Win95SetDefaultPrinter", errcode 'display the error message.
        End If
        canceled = True 'Set the Canceled flag and
        Exit Sub        'QUIT.
    End If

    'Set the members of the pi5 structure for use with SetPrinter.
    'PtrCtoVbString copies the memory pointed at by the two string
    'pointers contained in the t() array into a Visual Basic string.
    'The other three elements are just DWORDS (long integers) and
    'don't require any conversion
    pi5.pPrinterName = PtrCtoVbString(t(0))
    pi5.pPortName = PtrCtoVbString(t(1))
    pi5.Attributes = t(2)
    pi5.DeviceNotSelectedTimeout = t(3)
    pi5.TransmissionRetryTimeout = t(4)

    'This is the critical flag that makes it the default printer
    pi5.Attributes = PRINTER_ATTRIBUTE_DEFAULT

    'Call SetPrinter to set it
    x = SetPrinter(Handle, 5, pi5, 0)

    If x = False Then   'SetPrinter API failed
        errcode = CommDlgExtendedError()
        If errcode <> 0 Then                        'if it wasn't a CANCEL,
            error_message "Win95SetDefaultPrinter", errcode 'display the error message.
        End If
        canceled = True
        Exit Sub
    End If

    'Close the handle.
    ClosePrinter Handle
    
End Sub

'Routine to trnsfer data into a buffer and convert it into a VB string.
'Function name: PtrCtoVbString(Ad As Long)
'Parameter:     Ad; pointer to the memory string.

Private Function PtrCtoVbString(Ad As Long) As String

    Dim sTemp As String * 512   'Local buffer for string data.
    Dim x As Long
    
    x = lstrcpy(sTemp, Ad)
    
    'Look for Chr(0) as string terminator.
    If (InStr(1, sTemp, Chr(0)) = 0) Then 'no string found.
         PtrCtoVbString = ""
    Else    'Otherwise, store the text up to the deliminator.
         PtrCtoVbString = Left(sTemp, InStr(1, sTemp, Chr(0)) - 1)
    End If
    
End Function

'Routine to set the default printer on Win NT type systems.
'Procedure name:    WinNTSetDefaultPrinter(ByVal PrinterName as string)
'Parameter:         PrinterName;    the name of the required printer.

Private Sub WinNTSetDefaultPrinter(ByVal PrinterName As String)

    Dim buffer As String
    Dim DeviceName As String
    Dim DriverName As String
    Dim PrinterPort As String
    Dim r As Long
    
    'Get the printer information for the currently selected printer.
    'The information is taken from the WIN.INI file.
    buffer = Space(1024)
    r = GetProfileString("PrinterPorts", PrinterName, "", buffer, Len(buffer))

    'Parse the driver name and port name out of the buffer
    GetDriverAndPort buffer, DriverName, PrinterPort

    If DriverName <> "" And PrinterPort <> "" Then
        SetDefaultPrinter PrinterName, DriverName, PrinterPort
    End If
 
End Sub

'Routine to abstract the Driver and Port names from buffered data.
'Procedure name:    GetDriverAndPort Buffr, DrivrName, PrintrPort
'Parameters:        Buffr;  the buffer string,
'                   DrivrName;  the Driver name for return,
'                   PrintrPort; the Printer Port for return.

Private Sub GetDriverAndPort(ByVal Buffr As String, DrivrName As String, PrintrPort As String)

    Dim iDriver As Integer
    Dim iPort As Integer
    DrivrName = ""
    PrintrPort = ""

    'The driver name is first in the string terminated by a comma
    iDriver = InStr(Buffr, ",")
    If iDriver > 0 Then
        'Strip out the driver name
        DrivrName = Left(Buffr, iDriver - 1)

        'The port name is the second entry after the driver name
        'separated by commas.
        iPort = InStr(iDriver + 1, Buffr, ",")

        If iPort > 0 Then
            'Strip out the port name
            PrintrPort = Mid(Buffr, iDriver + 1, _
            iPort - iDriver - 1)
        End If
    End If

End Sub

'Routine to set the default printer.
'Procedure Name:    SetDefaultPrinter(ByVal PrinterName As String, ByVal DriverName
'                                     As String, ByVal PrinterPort As String)
'Parameters:        PrinterName;    the name of the required printer,
'                   DriverName;     the Printer Driver's name,
'                   PrinterPort;    the Printer Port.

Private Sub SetDefaultPrinter(ByVal PrinterName As String, ByVal DriverName As String, ByVal PrinterPort As String)
    
    Dim DeviceLine As String
    Dim r As Long
    Dim l As Long
    
    DeviceLine = PrinterName & "," & DriverName & "," & PrinterPort
    'Store the new printer information in the [WINDOWS] section of
    'the WIN.INI file for the DEVICE = item
    r = WriteProfileString("windows", "Device", DeviceLine)
    'Cause all applications to reload the INI file:
    l = SendMessage(HWND_BROADCAST, WM_WININICHANGE, 0, "windows")
    
End Sub

'Routine to make selected preferences global.
'Procedure name:    make_changes_global(PrinterName, media)
'Parameter:         PrinterName;    the selected printer name,
'                   media;          the media type code.

Private Sub make_changes_global(PrinterName, media)

    Dim mhPrinter As Long
    Dim pDef As PRINTER_DEFAULTS
    Dim lRet As Long
    Dim SizeNeeded As Long
    Dim buffer() As Long
    Dim l As Long
    Dim j As Integer
    
    OpenPrinter PrinterName, mhPrinter, pDef    'Get the Handle and Printer Defaults.
    
    If mhPrinter <> 0 Then
        'Get PRINTER_INFO_2 structure.
        ReDim Preserve buffer(0 To 1) As Long   'Set the initial buffer size and
        'use a GetPrinter call to find the size needed, (returns an error).
        lRet = GetPrinter(mhPrinter, 2, buffer(0), UBound(buffer), SizeNeeded)
        
        'Re-dimension the buffer to fit the size needed and call GetPrinter for real.
        ReDim Preserve buffer(0 To (SizeNeeded / 4) + 3) As Long
        lRet = GetPrinter(mhPrinter, 2, buffer(0), UBound(buffer) * 4, SizeNeeded)

        'Get the DEVMODE from it.
        Dim dmBase As DEVMODE_TYPE
 
        CopyMemoryDMBase dmBase, buffer(7), Len(dmBase)

        'Change the DEVMODE values to those selected by the user.
        dmBase.dmOrientation = Printer.Orientation
        dmBase.dmPaperSize = Printer.PaperSize
        dmBase.dmCopies = Printer.Copies
        dmBase.dmDefaultSource = Printer.PaperBin
        dmBase.dmPrintQuality = Printer.PrintQuality
        dmBase.dmColor = Printer.ColorMode
        dmBase.dmDuplex = Printer.Duplex
        If media > 0 Then
            dmBase.dmMediaType = media  'Change the media type if there is a value.
        End If
    
        'Set the required bits for the changed data flags,
        dmBase.DMFIELDS = DM_ORIENTATION + DM_PAPERSIZE + DM_COPIES + _
                          DM_DEFAULTSOURCE + DM_PRINTQUALITY + DM_COLOR + DM_DUPLEX
                          
        If media > 0 Then 'add the MediaType flag.
            dmBase.DMFIELDS = dmBase.DMFIELDS + DM_MEDIATYPE
        End If

        CopyMemoryFromDMBase buffer(7), dmBase, LenB(dmBase) 'Copy back the DEVMODE data.
        
        lRet = SetPrinter(mhPrinter, 2, buffer(0), 0)   'Save the PRINTER_INFO_2 data.

        ClosePrinter mhPrinter  'Close the printer to release the handle.
    End If
    
End Sub

'Routine to display the COLOUR selection window.
'Function name: ShowColor(ByVal huke As Long, ByVal flgs As Long) As Long
'Parameters;    huke;   hook,
'               flgs;   flags.

Public Function ShowColor(ByVal huke As Long, ByVal flgs As Long) As Long

    Dim cc As CHOOSECOLOR
    Dim Custcolor(16) As Long
    Dim lReturn As Long

    canceled = False            'Clear the canceled flag.
    
    cc.lStructSize = Len(cc)                            'Set the structure size.
    cc.hwndOwner = huke                                 'Set the owner.
    cc.hInstance = App.hInstance                        'Set the application's instance.
    cc.lpCustColors = StrConv(CustomColors, vbUnicode)  'Set the custom colors (converted to Unicode).
    cc.flags = flgs                                     'Set the flags.

    'Show the 'Select Color' dialog
    If CHOOSECOLOR(cc) <> 0 Then
        ShowColor = cc.rgbResult
        CustomColors = StrConv(cc.lpCustColors, vbFromUnicode)
    Else                                        'An error occured, or Cancel was pressed
        errcode = CommDlgExtendedError()        'Get the error code and,
        If errcode <> 0 Then                    'if it wasn't a CANCEL,
            error_message "ShowColor", errcode  'display the error message.
        End If
        
        canceled = True 'Set the canceled flag and
        ShowColor = -1  'return an error indicator.
    End If
   
End Function

'Routine to display the FONT selection window.
'Function name: ShowFont(ByVal huke As Long, ByVal flgs As Long) As string
'Parameters;    huke;   hook,
'               flgs;   flags.

Public Function ShowFont(ByVal huke As Long, ByVal flgs As Long) As String
 
    Dim cf As CHOOSEFONT, lfont As LOGFONT, hMem As Long, pMem As Long
    Dim fntname As String, retval As Long
    
    canceled = False
    
    On Error Resume Next
    
    lfont.lfHeight = 0              'Default height.
    lfont.lfWidth = 0               'Default width.
    lfont.lfEscapement = 0          'Angle between baseline and escapement vector.
    lfont.lfOrientation = 0         'Angle between baseline and orientation vector.
    lfont.lfWeight = FW_NORMAL      'Regular weight i.e. not bold.
    lfont.lfCharSet = DEFAULT_CHARSET               'Use default character set.
    lfont.lfOutPrecision = OUT_DEFAULT_PRECIS       'Default precision mapping.
    lfont.lfClipPrecision = CLIP_DEFAULT_PRECIS     'Default clipping precision.
    lfont.lfQuality = DEFAULT_QUALITY                   'Default quality setting.
    lfont.lfPitchAndFamily = DEFAULT_PITCH Or FF_ROMAN  'Default pitch, proportional with serifs.
    lfont.lfFaceName = def_font                         'Set default font.
    
    'Create the memory block which will act as the LOGFONT structure buffer.
    hMem = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(lfont))
    pMem = GlobalLock(hMem)                     'Lock and get pointer
    CopyMemory ByVal pMem, lfont, Len(lfont)    'Copy structure's contents into block.
    
    'Initialize dialog box: Screen and printer fonts, point size between 10 and 72.
    cf.lStructSize = Len(cf)        'Size of structure
    cf.hwndOwner = huke             'Set opening window.
    cf.hDC = Printer.hDC            'Device context of default printer (using VB's mechanism)
    cf.lpLogFont = pMem             'Pointer to LOGFONT memory block buffer
    cf.iPointSize = pt_sz           'Initial point size.
    cf.flags = flgs                 'Set flags.
    cf.rgbColors = RGB(0, 0, 0)     'Black text.
    cf.nFontType = REGULAR_FONTTYPE 'Regular font type i.e. not bold or anything
    cf.nSizeMin = sz_min            'Minimum point size
    cf.nSizeMax = sz_max            'Maximum point size
    
    'Now, call the function. If successful, copy the LOGFONT structure back into the structure
    'and then print out the attributes  mentioned earlier that the user selected.
    retval = CHOOSEFONT(cf)  ' open the dialog box
 
    If retval <> 0 Then 'it's OK, so
        CopyMemory lfont, ByVal pMem, Len(lfont)  'copy memory back.
        'Assign class font data values.
        font_size = cf.iPointSize / 10          'Store selected point size,
        font_weight = lfont.lfWeight            'weight as CONSTANT,
        font_italic = lfont.lfItalic            'italic flag,
        font_underline = lfont.lfUnderline      'underline flag,
        font_strikeout = lfont.lfStrikeOut      'strikeout flag,
        font_colour = cf.rgbColors              'and colour.
        'Make the fixed-length string holding the font name into a "normal" string.
        font_name = Left(lfont.lfFaceName, InStr(lfont.lfFaceName, vbNullChar) - 1)
        Debug.Print  'end the line
        ShowFont = font_name                    'Store the name.
    Else                                        'Otherwise, there was an error, so
        errcode = CommDlgExtendedError()        'get the error code and,
        If errcode <> 0 Then                    'if it wasn't a CANCEL,
            error_message "ShowOpen", errcode   'display the error message.
        End If
        canceled = True     'In case of error or a user CANCEL set the CANCELed flag and
        ShowFont = ""       'return an empty string as an error indicator.
    End If
    
    'Deallocate the memory block we created earlier. Note that this must
    'be done whether the function succeeded or not.
    retval = GlobalUnlock(hMem)     'Destroy the pointer, unlock block and
    retval = GlobalFree(hMem)       'free the allocated memory
    
End Function

'Routine to return font data.
'Procedure name:    FontData(op)
'Parameter:         op; the option number.

Public Function FontData(op) As Variant

    Select Case op
        Case 0 'is the font name.
            FontData = font_name
        Case 1
            FontData = font_size
        Case 2
            FontData = font_bold
        Case 3
            FontData = font_italic
        Case 4
            FontData = font_underline
        Case 5
            FontData = font_strikeout
        Case 6
            FontData = font_colour
        Case 7
            FontData = font_weight
        Case Else
            MsgBox "The parameter must be in the range 0 to 7 ", vbOKOnly, "FONT DATA ERROR"
            FontData = ""
    End Select
    
End Function

'Routine to display the PAGE SETUP window.
'This version has been modified to set and return the printer, ORIENTATION and
'PAPER SIZE, (code), via the PRINTER OBJECT itself and to return but not set the
'MARGINS and PAPER WIDTH and HEIGHT via the 'PageData' property.
 
'Any modifications to the size and orientation are applied to the default printer.

'Function name: PageSetupDlg(ByVal huke As Long, ByVal flgs As Long) As Long
'Parameters;    huke;   hook,
'               flgs;   flags.

Public Function ShowPageSetupDlg(ByVal huke, ByVal flgs As Long) As Long

    Dim m_PSD As PAGESETUPDLG
    Dim DevMode As DEVMODE_TYPE
    
    Dim lpDevMode As Long
    Dim bReturn, m_fact As Integer
    
    On Error Resume Next
    
    m_PSD.lStructSize = Len(m_PSD)  'Set the structure size
    m_PSD.hwndOwner = huke          'Set the owner window
    m_PSD.hInstance = App.hInstance 'Set the application instance
    m_PSD.flags = flgs              'Set flags.
    
    On Error Resume Next
    'Set the current orientation and duplex setting
    DevMode.dmSize = Len(DevMode)
    DevMode.DMFIELDS = DM_ORIENTATION Or DM_DUPLEX
    DevMode.dmPaperWidth = Printer.Width
    DevMode.dmOrientation = Printer.Orientation
    DevMode.dmPaperSize = Printer.PaperSize
    On Error GoTo 0
    
    'Allocate memory for the initialization hDevMode structure
    'and copy the settings gathered above into this memory
    m_PSD.hDevMode = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(DevMode))
    lpDevMode = GlobalLock(m_PSD.hDevMode)
    If lpDevMode > 0 Then
        CopyMemory ByVal lpDevMode, DevMode, Len(DevMode)
        bReturn = GlobalUnlock(m_PSD.hDevMode)
    End If
 
    'Show the pagesetup dialog
    If PAGESETUPDLG(m_PSD) Then 'it's Ok, so
        ShowPageSetupDlg = 0    'return a zero for success.
        
        'Find the units used.
        If (m_PSD.flags And cdlPSDInHundredthsofMillimeters) = cdlPSDInHundredthsofMillimeters Then
            m_fact = 100    'Factor for conversion of margins to mm.
            'Use a factor of 56.69 twips/mm to convert to twips.
            p_data(6) = 0   'Set the mm/" flag for return.
        Else
            m_fact = 1000   'Factor for conversion of margins to inches.
            'Use a factor of 1440 twips/in to convert to twips.
            p_data(6) = 1   'Set the mm/" flag for return.
        End If
 
        'Store the margins and paper size in mm or in.
        p_data(0) = m_PSD.rtMargin.Left / m_fact    'MARGINS,   Left,
        p_data(1) = m_PSD.rtMargin.Right / m_fact   '           Right,
        p_data(2) = m_PSD.rtMargin.Top / m_fact     '           Top,
        p_data(3) = m_PSD.rtMargin.Bottom / m_fact  '           Bottom.
        p_data(4) = m_PSD.ptPaperSize.x / m_fact    'PAPER,     Width,
        p_data(5) = m_PSD.ptPaperSize.y / m_fact    '           Height.
 
        'Get the DevMode structure and set the printer
        'properties appropriately
        lpDevMode = GlobalLock(m_PSD.hDevMode)
        CopyMemory DevMode, ByVal lpDevMode, Len(DevMode)
        bReturn = GlobalUnlock(m_PSD.hDevMode)
        GlobalFree m_PSD.hDevMode
        
        'Set the current printer orientation and paper size.
        Printer.Orientation = DevMode.dmOrientation
        Printer.PaperSize = DevMode.dmPaperSize
    Else                                                'Otherwise, there was an error, so
        errcode = CommDlgExtendedError()                'get the error code and,
        If errcode <> 0 Then                            'if it wasn't a CANCEL,
            error_message "ShowPageSetupDlg", errcode   'display the error message.
        End If
        canceled = True         'In case of error or a user CANCEL set the CANCELed flag and
        ShowPageSetupDlg = -1   'return an error flag value.
    End If
    
End Function

'Routine to return page data.
'Procedure name:    PageData(m_ar())
'Parameter:         m_ar(); the main program data array

Public Sub PageData(m_ar() As Single)

    Dim j As Integer
    
    For j = 0 To 6
        m_ar(j) = p_data(j)    'Transfer the data to the main program.
    Next

End Sub

'Error message routine.
'Reports on the error codes generated by the CommDlgExtendedError function.
'Procedure name:    error_message(ByVal fnct As String, ByVal er_cd as long)
'Parameter:         fnct;   the function/procedure name in which the error occured,
'                   er_cd;  the error code.

Sub error_message(ByVal fnct As String, ByVal er_cd As Long)
 
    Dim txt As String
    
    Select Case er_cd
        Case CDERR_DIALOGFAILURE        '&HFFFF
            txt = "The function could not open the dialog box."
        Case CDERR_GENERALCODES         '0
            txt = "The error involved a general common dialog box property."
        Case CDERR_STRUCTSIZE           '1
            txt = "The function was provided with an invalid structure size."
        Case CDERR_INITIALIZATION       '2
            txt = "The function failed during initialization (probably insufficient memory)."
        Case CDERR_NOTEMPLATE           '3
            txt = "The function was not provided with a valid template (if one was required)."
        Case CDERR_NOHINSTANCE          '4
            txt = "The function was not provided with a valid instance handle (if one was required)."
        Case CDERR_LOADSTRFAILURE       '5
            txt = "The function failed to load the desired string."
        Case CDERR_FINDRESFAILURE       '6
            txt = "The function failed to find the desired resource."
        Case CDERR_LOADRESFAILURE       '7
            txt = "The function failed to load the desired resource."
        Case CDERR_LOCKRESFAILURE       '8
            txt = "The function failed to lock the desired resource."
        Case CDERR_MEMALLOCFAILURE      '9
            txt = "The function failed to allocate sufficient memory."
        Case CDERR_MEMLOCKFAILURE       '&HA
            txt = "The function failed to lock the desired memory."
        Case CDERR_NOHOOK               '&HB
            txt = "The function was not provided with a valid hook function handle (if one was required)."
        Case CDERR_REGISTERMSGFAIL      '&HC
            txt = "The function failed to successfully register a window message."
        Case CFERR_CHOOSEFONTCODES      '&H2000
            txt = "The error involved the Choose Font common dialog box."
        Case CFERR_MAXLESSTHANMIN       '&H2002
            txt = "The function was provided with a maximum font size value smaller than the provided minimum font size."
        Case CFERR_NOFONTS              '&H2001
            txt = "The function could not find any existing fonts."
        Case FNERR_BUFFERTOOSMALL       '&H3003
            txt = "The function was provided with a filename buffer which was too small."
        Case FNERR_FILENAMECODES        '&H3000
            txt = "The error involved the Open File or Save File common dialog box."
        Case FNERR_INVALIDFILENAME      '&H3002
            txt = "The function was provided with or received an invalid filename."
        Case FNERR_SUBCLASSFAILURE      '&H3001
            txt = "The function had insufficient memory to subclass the list box."
        Case FRERR_BUFFERLENGTHZERO     '&H4001
            txt = "The function was provided with an invalid buffer."
        Case FRERR_FINDREPLACECODES     '&H4000
            txt = "The error involved the Find or Replace common dialog box."
        Case PDERR_CREATEICFAILURE      '&H100A
            txt = "The function failed to create an information context."
        Case PDERR_DEFAULTDIFFERENT     '&H100C
            txt = "The function was told that the information provided described the default printer," _
                  + " but the default printer's actual settings were different."
        Case PDERR_DNDMMISMATCH         'H1009
            txt = "The data in the two data structures describe different printers (i.e., they hold conflicting information)."
        Case PDERR_GETDEVMODEFAIL       '&H1005
            txt = "The printer driver failed to initialize the DEVMODE structure."
        Case PDERR_INITFAILURE          '&H1006
            txt = "The function failed during initialization."
        Case PDERR_LOADDRVFAILURE       '&H1004
            txt = "The function failed to load the desired device driver."
        Case PDERR_NODEFAULTPRN         '&H1008
            txt = "The function could not find a default printer."
        Case PDERR_NODEVICES            'H1007
            txt = "The function could not find any printers."
        Case PDERR_PARSEFAILURE         '&H1002
            txt = "The function failed to parse the printer-related strings in WIN.INI."
        Case PDERR_PRINTERCODES         '&H1000
            txt = "The error involved the Print common dialog box."
        Case PDERR_PRINTERNOTFOUND      '&H100B
            txt = "The function could not find information in WIN.INI about the requested printer."
        Case PDERR_RETDEFFAILURE        '&H1003
            txt = "The handles to the data structures provided were nonzero even though the function " _
                  + " was asked to return information about the default printer."
        Case PDERR_SETUPFAILURE         '&H1001
            txt = "The function failed to load the desired resources."
        Case Else
            txt = "Undocumented error."
    End Select
    
    MsgBox fnct + vbCrLf + vbCrLf + txt, vbOKOnly, "FUNCTION ERROR"
 
End Sub
